/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ActionExecuteHandlerDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.gson.impl.DateReadAdapter;

public class GsonActionExecutor
extends ActionExecuteHandlerDefault {
    private static final String label = "/json";
    private final GsonBuilder config = new GsonBuilder();
    private Gson gson;

    public GsonActionExecutor() {
        this.config.registerTypeAdapter(Date.class, (Object)new DateReadAdapter());
    }

    public GsonBuilder config() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gson gson() {
        if (this.gson == null) {
            GsonActionExecutor gsonActionExecutor = this;
            synchronized (gsonActionExecutor) {
                if (this.gson == null) {
                    this.gson = this.config.create();
                }
            }
        }
        return this.gson;
    }

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        String json = ctx.bodyNew();
        if (Utils.isNotEmpty((String)json)) {
            return JsonParser.parseString((String)json);
        }
        return null;
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (!p.isRequiredBody() && ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JsonObject) {
            JsonObject tmp = (JsonObject)bodyObj;
            if (!p.isRequiredBody() && tmp.has(p.getName())) {
                if (p.isGenericType()) {
                    return this.gson().fromJson(tmp.get(p.getName()), p.getGenericType());
                }
                return this.gson().fromJson(tmp.get(p.getName()), pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(p.getType())) {
                return null;
            }
            if (p.getType().isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return this.gson().fromJson((JsonElement)tmp, p.getGenericType());
            }
            return this.gson().fromJson((JsonElement)tmp, pt);
        }
        if (bodyObj instanceof JsonArray) {
            JsonArray tmp = (JsonArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return this.gson().fromJson((JsonElement)tmp, p.getGenericType());
            }
            return this.gson().fromJson((JsonElement)tmp, p.getType());
        }
        return bodyObj;
    }
}

