/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.ParamWrap;

public class Fastjson2ActionExecutor
extends ActionExecutorDefault {
    private static final String label = "/json";
    private final JSONReader.Context config = JSONFactory.createReadContext();

    public JSONReader.Context config() {
        return this.config;
    }

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx) throws Exception {
        String json = ctx.bodyNew();
        if (Utils.isNotEmpty((String)json)) {
            return JSON.parse((String)json, (JSONReader.Context)this.config);
        }
        return null;
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (tmp.containsKey(p.getName())) {
                ParameterizedType gp = p.getGenericType();
                if (gp != null) {
                    return tmp.getObject(p.getName(), (Type)gp, new JSONReader.Feature[0]);
                }
                return tmp.getObject(p.getName(), pt, new JSONReader.Feature[0]);
            }
            if (ctx.paramMap().containsKey((Object)p.getName())) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(p.getType())) {
                return null;
            }
            if (p.getType().isArray()) {
                return null;
            }
            ParameterizedType gp = p.getGenericType();
            if (gp != null) {
                return tmp.to((Type)gp, new JSONReader.Feature[0]);
            }
            return tmp.to(pt, new JSONReader.Feature[0]);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            ParameterizedType gp = p.getGenericType();
            if (gp != null) {
                return tmp.to((Type)gp);
            }
            return tmp.to(p.getType());
        }
        return bodyObj;
    }
}

