/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.retry;

import org.noear.solon.core.AopContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.scheduling.annotation.Retry;
import org.noear.solon.scheduling.retry.Recover;
import org.noear.solon.scheduling.retry.RetryableTask;

public class RetryInterceptor
implements Interceptor {
    AopContext aopContext;

    public RetryInterceptor(AopContext aopContext) {
        this.aopContext = aopContext;
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Retry anno = (Retry)inv.method().getAnnotation(Retry.class);
        if (anno != null) {
            return RetryableTask.of(() -> {
                try {
                    return inv.method().getMethod().invoke(inv.target(), inv.args());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).maxRetryCount(anno.maxAttempts()).interval(anno.interval()).unit(anno.unit()).recover((Recover)this.aopContext.getBeanOrNew(anno.recover())).retryForExceptions(anno.exs()).execute().get();
        }
        return inv.invoke();
    }
}

