/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.simple.cron.CronExpressionPlus;
import org.noear.solon.scheduling.simple.cron.CronUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduler
implements Lifecycle {
    static final Logger log = LoggerFactory.getLogger(SimpleScheduler.class);
    private JobHolder jobHolder;
    private CronExpressionPlus cron;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;
    private Thread jobThreadOfCron;
    private ScheduledFuture<?> jobFutureOfFixed;
    boolean isStarted = false;

    public SimpleScheduler(JobHolder jobHolder) {
        this.jobHolder = jobHolder;
        if (Utils.isNotEmpty((String)jobHolder.getScheduled().cron())) {
            this.cron = CronUtils.get(jobHolder.getScheduled().cron());
            if (Utils.isNotEmpty((String)jobHolder.getScheduled().zone())) {
                this.cron.setTimeZone(TimeZone.getTimeZone(jobHolder.getScheduled().zone()));
            }
        }
    }

    public void start() throws Throwable {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.jobHolder.getScheduled().fixedDelay() > 0L) {
            this.jobFutureOfFixed = RunUtil.scheduleWithFixedDelay(this::exec0, (long)this.jobHolder.getScheduled().initialDelay(), (long)this.jobHolder.getScheduled().fixedDelay());
        } else if (this.jobHolder.getScheduled().fixedRate() > 0L) {
            this.jobFutureOfFixed = RunUtil.scheduleAtFixedRate(this::exec0, (long)this.jobHolder.getScheduled().initialDelay(), (long)this.jobHolder.getScheduled().fixedRate());
        } else {
            this.jobThreadOfCron = new Thread(this::run);
            if (Utils.isNotEmpty((String)this.jobHolder.getName())) {
                this.jobThreadOfCron.setName("Job:" + this.jobHolder.getName());
            }
            this.jobThreadOfCron.start();
        }
    }

    public void stop() throws Throwable {
        this.isStarted = false;
        if (false) {
            return;
        }
        this.isStarted = false;
        if (this.jobThreadOfCron != null) {
            this.jobThreadOfCron.interrupt();
        }
        if (this.jobFutureOfFixed != null) {
            this.jobFutureOfFixed.cancel(false);
        }
    }

    private void run() {
        if (this.baseTime == null) {
            this.baseTime = new Date();
        }
        while (this.isStarted) {
            try {
                this.runAsCron();
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                if (e instanceof InterruptedException) continue;
                log.warn(e.getMessage(), e);
            }
        }
    }

    private void runAsCron() throws Throwable {
        this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
        this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
        if (this.sleepMillis >= 0L) {
            this.baseTime = this.nextTime;
            this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
            if (this.sleepMillis <= 1000L) {
                RunUtil.parallel(this::exec0);
                this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            }
        }
        this.sleep0(this.sleepMillis);
    }

    private void exec0() {
        try {
            this.jobHolder.handle(null);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void sleep0(long millis) {
        if (millis < 0L) {
            millis = 100L;
        }
        try {
            Thread.sleep(millis);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

