/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.simple;

import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.scheduling.ScheduledException;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.simple.cron.CronExpressionPlus;
import org.noear.solon.scheduling.simple.cron.CronUtils;

public class JobHolder
extends Thread {
    private CronExpressionPlus cron;
    private Scheduled anno;
    final Runnable runnable;
    private boolean isCanceled;
    private long sleepMillis;
    private Date baseTime;
    private Date nextTime;

    public JobHolder(String name, Scheduled anno, Runnable runnable) {
        if (anno.fixedRate() == 0L) {
            this.cron = CronUtils.get(anno.cron());
            if (Utils.isNotEmpty((String)anno.zone())) {
                this.cron.setTimeZone(TimeZone.getTimeZone(anno.zone()));
            }
        }
        this.anno = anno;
        this.runnable = runnable;
        this.baseTime = new Date();
        if (Utils.isNotEmpty((String)name)) {
            this.setName("Job:" + name);
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    @Override
    public void run() {
        if (this.anno.fixedDelay() > 0L) {
            this.sleep0(this.anno.fixedDelay());
        }
        while (!this.isCanceled) {
            try {
                this.scheduling();
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                EventBus.push((Object)new ScheduledException(e));
            }
        }
    }

    private void scheduling() throws Throwable {
        if (this.anno.fixedRate() > 0L) {
            this.sleepMillis = System.currentTimeMillis() - this.baseTime.getTime();
            if (this.sleepMillis >= this.anno.fixedRate()) {
                this.baseTime = new Date();
                this.exec();
                this.sleepMillis = this.anno.fixedRate();
            } else {
                this.sleepMillis = 100L;
            }
            this.sleep0(this.sleepMillis);
        } else {
            this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
            this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
            if (this.sleepMillis >= 0L) {
                this.baseTime = this.nextTime;
                this.nextTime = this.cron.getNextValidTimeAfter(this.baseTime);
                if (this.sleepMillis <= 1000L) {
                    this.exec();
                    this.sleepMillis = System.currentTimeMillis() - this.nextTime.getTime();
                }
            }
            this.sleep0(this.sleepMillis);
        }
    }

    private void exec() {
        Utils.parallel(this::exec0);
    }

    private void exec0() {
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            EventBus.push((Object)e);
        }
    }

    private void sleep0(long sleep) {
        if (sleep < 0L) {
            sleep = 100L;
        }
        try {
            Thread.sleep(sleep);
        }
        catch (Exception e) {
            EventBus.push((Object)e);
        }
    }
}

