/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz.integration;

import java.lang.reflect.Method;
import org.noear.solon.scheduling.quartz.AbstractJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MethodJob
extends AbstractJob {
    private final String jobId;
    private final Object target;
    private final Method method;
    private final boolean isRunnable;

    public MethodJob(Object target, Method method) {
        this.target = target;
        this.method = method;
        this.isRunnable = method.getParameterCount() == 0;
        this.jobId = target.getClass().getName() + "::" + method.getName();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            if (this.isRunnable) {
                this.method.invoke(this.target, new Object[0]);
            } else {
                this.method.invoke(this.target, context);
            }
        }
        catch (Throwable e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }
}

