/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.listener.ExpressWebSocketListener;
import org.noear.solon.net.websocket.listener.PathWebSocketListener;
import org.noear.solon.net.websocket.listener.PipelineWebSocketListener;

public class WebSocketRouter {
    private final PipelineWebSocketListener rootListener = new PipelineWebSocketListener();
    private final PathWebSocketListener pathListener = new PathWebSocketListener(true);
    private final Set<String> paths = new HashSet<String>();

    private WebSocketRouter() {
        this.rootListener.next(this.pathListener);
    }

    public static WebSocketRouter getInstance() {
        return (WebSocketRouter)Solon.context().attachmentOf(WebSocketRouter.class, WebSocketRouter::new);
    }

    public void before(WebSocketListener listener) {
        this.rootListener.prev(listener);
    }

    public void beforeIfAbsent(WebSocketListener listener) {
        this.rootListener.prevIfAbsent(listener);
    }

    public void of(String path, WebSocketListener listener) {
        this.pathListener.of(path, listener);
        this.paths.add(path);
    }

    public void after(WebSocketListener listener) {
        this.rootListener.next(listener);
    }

    public void afterIfAbsent(WebSocketListener listener) {
        this.rootListener.nextIfAbsent(listener);
    }

    public WebSocketListener getListener() {
        return this.rootListener;
    }

    public Collection<String> getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public SubProtocolCapable getSubProtocol(String path) {
        WebSocketListener tmp = this.matching(path);
        if (tmp != null) {
            if (tmp instanceof ExpressWebSocketListener) {
                tmp = ((ExpressWebSocketListener)tmp).getListener();
            }
            if (tmp instanceof SubProtocolCapable) {
                return (SubProtocolCapable)((Object)tmp);
            }
        }
        return null;
    }

    public WebSocketListener matching(String path) {
        return this.pathListener.matching(path);
    }
}

