/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.socketd.handle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.FileEntity;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.net.socketd.handle.SocketdSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketdContext
extends ContextEmpty {
    static final Logger log = LoggerFactory.getLogger(SocketdContext.class);
    private Session _session;
    private Message _request;
    private EntityDefault _response;
    private MethodType _method;
    private URI _uri;
    private InputStream bodyAsStream;
    ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();

    public SocketdContext(Session session, Message message) throws IOException {
        this._session = session;
        this._request = message;
        this._response = new EntityDefault();
        this._method = MethodType.SOCKET;
        if (session.handshake().paramMap().size() > 0) {
            this.headerMap().putAll(session.handshake().paramMap());
        }
        if (Utils.isNotEmpty((String)message.metaString())) {
            this.headerMap().putAll(message.metaMap());
        }
        this.sessionState = new SocketdSessionState(this._session);
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        try {
            return this._session.remoteAddress().getAddress().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int remotePort() {
        try {
            return this._session.remoteAddress().getPort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return this._method.name;
    }

    public String protocol() {
        return this._session.handshake().uri().getScheme();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String url() {
        return this._request.event();
    }

    public long contentLength() {
        return this._request.dataSize();
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String queryString() {
        return this.uri().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new ByteArrayInputStream(this._request.dataAsBytes());
        }
        return this.bodyAsStream;
    }

    public Object response() {
        return this._session;
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public void headerSet(String key, String val) {
        this._response.metaPut(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.metaPut(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.meta(name);
    }

    public OutputStream outputStream() {
        return this._outputStream;
    }

    public void output(byte[] bytes) {
        try {
            this.outputStream().write(bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            IoUtil.transferTo((InputStream)stream, (OutputStream)this.outputStream());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void outputAsFile(File file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        String contentType = Utils.mime((String)file.getName());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(contentType);
        long len = file.length();
        FileEntity fileEntity = new FileEntity(file);
        this.replyDo(fileEntity.data(), (int)len);
        fileEntity.release();
    }

    public void outputAsFile(DownloadedFile file) throws IOException {
        String fileName = URLEncoder.encode(file.getName(), Solon.encoding());
        this.headerSet("Data-Disposition-Filename", fileName);
        this.contentType(file.getContentType());
        byte[] bytes = IoUtil.transferToBytes((InputStream)file.getContent());
        this.replyDo(ByteBuffer.wrap(bytes), (int)file.getContentSize());
    }

    protected void commit() throws IOException {
        this.replyDo(ByteBuffer.wrap(this._outputStream.toByteArray()), this._outputStream.size());
    }

    private void replyDo(ByteBuffer dataStream, int dataSize) throws IOException {
        if (this._request.isRequest() || this._request.isSubscribe()) {
            this._response.dataSet(dataStream);
            this._session.replyEnd(this._request, (Entity)this._response);
        } else if (dataSize > 0) {
            log.warn("No reply is supported for the current message, sid={}", (Object)this._request.sid());
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
    }

    public void asyncComplete() {
    }

    public void close() throws IOException {
        this._session.close();
    }
}

