/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.socketd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToSocketdWebSocketListener
implements WebSocketListener {
    static final String SOCKETD_KEY = "SOCKETD_KEY";
    static final Logger log = LoggerFactory.getLogger(ToSocketdWebSocketListener.class);
    private final Config config;
    private final InnerChannelAssistant assistant;
    private final Processor processor;
    private final InnerChannelSupporter supporter;

    public ToSocketdWebSocketListener(Config config) {
        this(config, null);
    }

    public ToSocketdWebSocketListener(Config config, Listener listener) {
        this.config = config;
        this.assistant = new InnerChannelAssistant(config);
        this.processor = new ProcessorDefault();
        this.supporter = new InnerChannelSupporter(this);
        if (listener == null) {
            if (this instanceof Listener) {
                this.setListener((Listener)this);
            }
        } else {
            this.setListener(listener);
        }
    }

    public void setListener(Listener listener) {
        this.processor.setListener(listener);
    }

    private ChannelInternal getChannel(WebSocket socket) {
        ChannelInternal channel = (ChannelInternal)socket.attr(SOCKETD_KEY);
        if (channel == null) {
            channel = new ChannelDefault((Object)socket, (ChannelSupporter)this.supporter);
            socket.attr(SOCKETD_KEY, channel);
        }
        return channel;
    }

    @Override
    public void onOpen(WebSocket socket) {
        this.getChannel(socket);
    }

    @Override
    public void onMessage(WebSocket socket, String text) throws IOException {
        if (log.isWarnEnabled()) {
            log.warn("Unsupported onMessage(String test)");
        }
    }

    @Override
    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        try {
            ChannelInternal channel = this.getChannel(socket);
            Frame frame = this.assistant.read(binary);
            if (frame != null) {
                this.processor.onReceive(channel, frame);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void onClose(WebSocket socket) {
        try {
            ChannelInternal channel = this.getChannel(socket);
            this.processor.onClose(channel);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void onError(WebSocket socket, Throwable error) {
        try {
            ChannelInternal channel = this.getChannel(socket);
            if (channel != null) {
                this.processor.onError(channel, error);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void onPing(WebSocket socket) {
        this.assertHandshake(socket);
    }

    @Override
    public void onPong(WebSocket socket) {
        this.assertHandshake(socket);
    }

    protected boolean assertHandshake(WebSocket conn) {
        ChannelInternal channel = this.getChannel(conn);
        if (channel == null || channel.getHandshake() == null) {
            conn.close();
            if (log.isWarnEnabled()) {
                log.warn("Server channel no handshake onPingPong");
            }
            return false;
        }
        return true;
    }

    private static class InnerChannelAssistant
    implements ChannelAssistant<WebSocket> {
        private final Config config;

        public InnerChannelAssistant(Config config) {
            this.config = config;
        }

        public void write(WebSocket target, Frame frame) throws IOException {
            ByteBufferCodecWriter writer = (ByteBufferCodecWriter)this.config.getCodec().write(frame, len -> new ByteBufferCodecWriter(ByteBuffer.allocate(len)));
            target.send(writer.getBuffer());
        }

        public Frame read(ByteBuffer buffer) throws IOException {
            return this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
        }

        public boolean isValid(WebSocket target) {
            return target.isValid();
        }

        public void close(WebSocket target) throws IOException {
            target.close();
        }

        public InetSocketAddress getRemoteAddress(WebSocket target) throws IOException {
            return target.remoteAddress();
        }

        public InetSocketAddress getLocalAddress(WebSocket target) throws IOException {
            return target.localAddress();
        }
    }

    private static class InnerChannelSupporter
    implements ChannelSupporter<WebSocket> {
        private ToSocketdWebSocketListener l;

        InnerChannelSupporter(ToSocketdWebSocketListener l) {
            this.l = l;
        }

        public Processor getProcessor() {
            return this.l.processor;
        }

        public ChannelAssistant<WebSocket> getAssistant() {
            return this.l.assistant;
        }

        public Config getConfig() {
            return this.l.config;
        }
    }
}

