/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.Handshake;

public class HandshakeImpl
implements Handshake {
    private final String url;
    private final URI uri;
    private final Map<String, String> paramMap;

    public HandshakeImpl(URI uri) {
        this.uri = uri;
        this.url = uri.toString();
        this.paramMap = new HashMap<String, String>();
        String queryString = uri.getQuery();
        if (Utils.isNotEmpty((String)queryString)) {
            for (String kvStr : queryString.split("&")) {
                int idx = kvStr.indexOf(61);
                if (idx <= 1) continue;
                this.paramMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
            }
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getParamMap() {
        return this.paramMap;
    }
}

