/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.socketd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.solon.net.websocket.WebSocket;

public class WebSocketChannelAssistant
implements ChannelAssistant<WebSocket> {
    private final Config config;

    public WebSocketChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(WebSocket target, Frame frame) throws IOException {
        ByteBufferCodecWriter writer = (ByteBufferCodecWriter)this.config.getCodec().write(frame, len -> new ByteBufferCodecWriter(ByteBuffer.allocate(len)));
        target.send(writer.getBuffer());
    }

    public Frame read(ByteBuffer buffer) throws IOException {
        return this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
    }

    public boolean isValid(WebSocket target) {
        return target.isValid();
    }

    public void close(WebSocket target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(WebSocket target) throws IOException {
        return target.remoteAddress();
    }

    public InetSocketAddress getLocalAddress(WebSocket target) throws IOException {
        return target.localAddress();
    }
}

