/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.socketd;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.socketd.WebSocketChannelAssistant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToSocketdWebSocketListener
implements WebSocketListener {
    static final String SOCKETD_KEY = "SOCKETD_KEY";
    static final Logger log = LoggerFactory.getLogger(ToSocketdWebSocketListener.class);
    private final Config config;
    private final WebSocketChannelAssistant assistant;
    private final Processor processor;
    private final InnerChannelSupporter supporter;

    public ToSocketdWebSocketListener(Config config, Listener listener) {
        this.config = config;
        this.assistant = new WebSocketChannelAssistant(config);
        this.processor = new ProcessorDefault();
        this.processor.setListener(listener);
        this.supporter = new InnerChannelSupporter(this);
    }

    private ChannelInternal getChannel(WebSocket socket) {
        ChannelInternal channel = (ChannelInternal)socket.attr(SOCKETD_KEY);
        if (channel == null) {
            channel = new ChannelDefault((Object)socket, (ChannelSupporter)this.supporter);
            socket.attr(SOCKETD_KEY, channel);
        }
        return channel;
    }

    @Override
    public void onOpen(WebSocket socket) {
        this.getChannel(socket);
    }

    @Override
    public void onMessage(WebSocket socket, String text) throws IOException {
        if (log.isWarnEnabled()) {
            log.warn("Unsupported onMessage(String test)");
        }
    }

    @Override
    public void onMessage(WebSocket socket, ByteBuffer binary) throws IOException {
        try {
            ChannelInternal channel = this.getChannel(socket);
            Frame frame = this.assistant.read(binary);
            if (frame != null) {
                this.processor.onReceive(channel, frame);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void onClose(WebSocket socket) {
        try {
            ChannelInternal channel = this.getChannel(socket);
            this.processor.onClose(channel);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void onError(WebSocket socket, Throwable error) {
        try {
            ChannelInternal channel = this.getChannel(socket);
            if (channel != null) {
                this.processor.onError(channel, error);
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private static class InnerChannelSupporter
    implements ChannelSupporter<WebSocket> {
        private ToSocketdWebSocketListener l;

        InnerChannelSupporter(ToSocketdWebSocketListener l) {
            this.l = l;
        }

        public Processor getProcessor() {
            return this.l.processor;
        }

        public ChannelAssistant<WebSocket> getAssistant() {
            return this.l.assistant;
        }

        public Config getConfig() {
            return this.l.config;
        }
    }
}

