/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.socketd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.buffer.BufferReader;
import org.noear.socketd.transport.core.buffer.ByteBufferReader;
import org.noear.socketd.transport.core.buffer.ByteBufferWriter;
import org.noear.solon.net.websocket.WebSocket;

public class WebSocketChannelAssistant
implements ChannelAssistant<WebSocket> {
    private final Config config;

    public WebSocketChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(WebSocket target, Frame frame) throws IOException {
        ByteBufferWriter writer = (ByteBufferWriter)this.config.getCodec().write(frame, len -> new ByteBufferWriter(ByteBuffer.allocate(len)));
        target.send(writer.getBuffer());
    }

    public Frame read(ByteBuffer buffer) throws IOException {
        return this.config.getCodec().read((BufferReader)new ByteBufferReader(buffer));
    }

    public boolean isValid(WebSocket target) {
        return target.isValid();
    }

    public void close(WebSocket target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(WebSocket target) throws IOException {
        return target.remoteAddress();
    }

    public InetSocketAddress getLocalAddress(WebSocket target) throws IOException {
        return target.localAddress();
    }
}

