/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.listener.ExpressWebSocketListener;

public class RouterWebSocketListener
implements WebSocketListener {
    private final RoutingTable<WebSocketListener> routingTable = new RoutingTableDefault();

    public int count() {
        return this.routingTable.count();
    }

    public RouterWebSocketListener of(String path, int index, WebSocketListener listener) {
        ExpressWebSocketListener lh = new ExpressWebSocketListener(path, listener);
        this.routingTable.add((Routing)new RoutingDefault(path, MethodType.SOCKET, index, (Object)lh));
        return this;
    }

    public RouterWebSocketListener of(String path, WebSocketListener listener) {
        return this.of(path, 0, listener);
    }

    public RouterWebSocketListener remove(String path) {
        this.routingTable.remove(path);
        return this;
    }

    protected WebSocketListener matching(WebSocket s) {
        String path = s.path();
        if (path == null) {
            return null;
        }
        return (WebSocketListener)this.routingTable.matchOne(path, MethodType.SOCKET);
    }

    @Override
    public void onOpen(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onOpen(s);
        }
    }

    @Override
    public void onMessage(WebSocket s, String text) throws IOException {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onMessage(s, text);
        }
    }

    @Override
    public void onMessage(WebSocket s, ByteBuffer binary) throws IOException {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onMessage(s, binary);
        }
    }

    @Override
    public void onClose(WebSocket s) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onClose(s);
        }
    }

    @Override
    public void onError(WebSocket s, Throwable error) {
        WebSocketListener l1 = this.matching(s);
        if (l1 != null) {
            l1.onError(s, error);
        }
    }
}

