/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.persistent;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.noear.solon.logging.persistent.PackagingQueueTask;
import org.noear.solon.logging.persistent.PackagingWorkHandler;

public class PackagingQueueTaskImpl<Event>
implements PackagingQueueTask<Event>,
Closeable {
    private long interval = 500L;
    private final long interval_min = 100L;
    private int packetSize = 150;
    private final int packetSize_min = 150;
    private Thread workThread;
    private PackagingWorkHandler<Event> workHandler;
    private Queue<Event> queueLocal = new LinkedBlockingQueue<Event>();
    private boolean isStopped = false;

    public PackagingQueueTaskImpl() {
        this.workThread = new Thread(() -> this.workStartDo(), "Simple task");
        this.workThread.start();
    }

    @Override
    public void setWorkHandler(PackagingWorkHandler<Event> workHandler) {
        this.workHandler = workHandler;
    }

    @Override
    public void add(Event event) {
        try {
            this.queueLocal.add(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addAll(Collection<Event> events) {
        try {
            this.queueLocal.addAll(events);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        if (interval >= 100L) {
            this.interval = interval;
        }
    }

    @Override
    public void setPacketSize(int packetSize) {
        if (packetSize >= 150) {
            this.packetSize = packetSize;
        }
    }

    private void workStartDo() {
        while (!this.isStopped) {
            try {
                long time_start = System.currentTimeMillis();
                this.workExecDo();
                long time_end = System.currentTimeMillis();
                if (this.getInterval() == 0L) {
                    return;
                }
                if (time_end - time_start >= this.getInterval()) continue;
                Thread.sleep(this.getInterval());
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    private void workExecDo() throws Exception {
        if (this.workHandler == null) {
            return;
        }
        while (true) {
            if (this.isStopped) {
                return;
            }
            ArrayList list = new ArrayList(this.packetSize);
            this.collectDo(list);
            if (list.size() <= 0) break;
            this.workHandler.onEvents(list);
        }
    }

    private void collectDo(List<Event> list) {
        int count = 0;
        do {
            if (this.isStopped) {
                return;
            }
            Event event = this.queueLocal.poll();
            if (event == null) break;
            list.add(event);
        } while (++count != this.packetSize);
    }

    @Override
    public void close() throws IOException {
        this.isStopped = true;
    }
}

