/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.integration.log4j;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

@Plugin(name="SolonAppender", category="Core", elementType="appender", printObject=true)
public final class SolonAppender
extends AbstractAppender {
    protected SolonAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    public void append(org.apache.logging.log4j.core.LogEvent e) {
        Level level = Level.INFO;
        int eLevel = e.getLevel().intLevel();
        level = StandardLevel.DEBUG.intLevel() == eLevel ? Level.DEBUG : (StandardLevel.WARN.intLevel() == eLevel ? Level.WARN : (StandardLevel.INFO.intLevel() == eLevel ? Level.INFO : (StandardLevel.TRACE.intLevel() == eLevel ? Level.TRACE : Level.ERROR)));
        ReadOnlyStringMap eData = e.getContextData();
        LogEvent event = new LogEvent(e.getLoggerName(), level, eData == null ? null : eData.toMap(), e.getMessage(), e.getTimeMillis(), e.getThreadName(), e.getThrown());
        AppenderManager.getInstance().append(event);
    }

    @PluginFactory
    public static SolonAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
        if (name == null) {
            LOGGER.error("No name provided for MyCustomAppenderImpl");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new SolonAppender(name, filter, (Layout<? extends Serializable>)layout, true);
    }
}

