/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging.event;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.LogOptions;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.logging.event.LogEvent;

public class AppenderSimple
implements Appender {
    protected static Appender instance = new AppenderSimple();

    @Override
    public String getName() {
        return "simple";
    }

    @Override
    public void append(LogEvent logEvent) {
        if (LogOptions.getLevel().code > logEvent.getLevel().code) {
            return;
        }
        this.appendDo(logEvent);
    }

    protected void appendDo(LogEvent logEvent) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(new Date(logEvent.getTimeStamp()).toInstant(), ZoneId.systemDefault());
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(logEvent.getLevel().name()).append("] ");
        buf.append(dateTime.toString()).append(" ");
        buf.append("[*").append(Thread.currentThread().getName()).append("]");
        if (logEvent.getMetainfo() != null) {
            logEvent.getMetainfo().forEach((k, v) -> buf.append("[@").append((String)k).append(":").append((String)v).append("]"));
        }
        if (logEvent.getInitClass() != null) {
            buf.append(" ").append(logEvent.getInitClass().getTypeName()).append("#").append(this.getName());
        } else {
            buf.append(" ").append(logEvent.getLoggerName()).append("#").append(this.getName());
        }
        buf.append(":\r\n");
        switch (logEvent.getLevel()) {
            case ERROR: {
                PrintUtil.red((String)buf.toString());
                break;
            }
            case WARN: {
                PrintUtil.yellow((String)buf.toString());
                break;
            }
            case DEBUG: {
                PrintUtil.blue((String)buf.toString());
                break;
            }
            default: {
                PrintUtil.black((String)buf.toString());
            }
        }
        this.appendContentDo(logEvent.getContent());
    }

    protected void appendContentDo(Object content) {
        System.out.println(content);
    }
}

