/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.impl;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.i18n.I18nBundle;

public class I18nBundleLocal
implements I18nBundle {
    Properties bundle;
    String bundleName;
    Locale locale;
    Map<String, String> map;

    public I18nBundleLocal(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.bundleName = bundleName;
        String bundleName2 = bundleName.replace(".", "/");
        this.bundle = Utils.loadProperties((String)(bundleName2 + "_" + locale.toString() + ".properties"));
        if (this.bundle == null) {
            this.bundle = Utils.loadProperties((String)(bundleName2 + ".properties"));
        }
    }

    @Override
    public synchronized Map<String, String> toMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, String>();
            for (Object k : this.bundle.keySet()) {
                String key = (String)k;
                this.map.put(key, this.get(key));
            }
        }
        return this.map;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    @Override
    public String get(String key) {
        String tmp = this.bundle.getProperty(key);
        if (tmp == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.bundleName + ", key " + key, this.getClass().getName(), key);
        }
        return tmp;
    }
}

