/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector.impl;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.health.detector.AbstractDetector;

public class MemoryDetector
extends AbstractDetector {
    @Override
    public String getName() {
        return "memory";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long total = osmxb.getTotalPhysicalMemorySize();
        long free = osmxb.getFreePhysicalMemorySize();
        long used = total - free;
        info.put("total", MemoryDetector.formatByteSize(total));
        info.put("used", MemoryDetector.formatByteSize(used));
        if (total > 0L) {
            float ratio = (float)used * 100.0f / (float)total;
            info.put("ratio", Float.valueOf(ratio));
        }
        return info;
    }
}

