/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.health.detector.Detector;

public abstract class AbstractDetector
implements Detector {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;
    public static final long ONE_EB = 0x1000000000000000L;
    protected static final String osName = System.getProperty("os.name").toLowerCase();

    @Override
    public abstract String getName();

    @Override
    public abstract Map<String, Object> getInfo();

    protected List<String[]> matcher(Pattern pattern, String text) throws Exception {
        ArrayList<String[]> infos = new ArrayList<String[]>();
        if (Utils.isNotEmpty((String)text)) {
            String[] lines;
            for (String line : lines = text.trim().split("\\n")) {
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    String[] info = new String[matcher.groupCount() + 1];
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        info[i] = matcher.group(i).trim();
                    }
                    infos.add(info);
                }
            }
        }
        return infos;
    }

    protected static String formatByteSize(long byteSize) {
        double dataSize = byteSize;
        if (dataSize >= 1.152921504606847E18) {
            return (double)Math.round(dataSize / 1.152921504606847E18 * 100.0) / 100.0 + "EB";
        }
        if (dataSize >= 1.125899906842624E15) {
            return (double)Math.round(dataSize / 1.125899906842624E15 * 100.0) / 100.0 + "PB";
        }
        if (dataSize >= 1.099511627776E12) {
            return (double)Math.round(dataSize / 1.099511627776E12 * 100.0) / 100.0 + "TB";
        }
        if (dataSize >= 1.073741824E9) {
            return (double)Math.round(dataSize / 1.073741824E9 * 100.0) / 100.0 + "GB";
        }
        if (dataSize >= 1048576.0) {
            return (double)Math.round(dataSize / 1048576.0 * 100.0) / 100.0 + "MB";
        }
        if (dataSize >= 1024.0) {
            return (double)Math.round(dataSize / 1024.0 * 100.0) / 100.0 + "KB";
        }
        if (dataSize > 0.0) {
            return Math.round(dataSize) + "B";
        }
        return "0";
    }
}

