/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.ArrayModel;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.solon.annotation.ApiRes;
import io.swagger.solon.annotation.ApiResProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Gateway;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.exception.DocException;
import org.noear.solon.docs.models.ApiContact;
import org.noear.solon.docs.models.ApiLicense;
import org.noear.solon.docs.models.ApiScheme;
import org.noear.solon.docs.openapi2.impl.ActionHolder;
import org.noear.solon.docs.openapi2.impl.BuilderHelper;
import org.noear.solon.docs.openapi2.impl.ParamHolder;

public class OpenApi2Builder {
    private final Swagger swagger = new Swagger();
    private final DocDocket docket;
    private ModelImpl globalResultModel;

    public OpenApi2Builder(DocDocket docket) {
        this.docket = docket;
    }

    public Swagger build() {
        if (this.docket.globalResult() != null) {
            this.globalResultModel = (ModelImpl)this.parseSwaggerModel(this.docket.globalResult(), this.docket.globalResult());
        }
        this.parseGroupPackage();
        ApiLicense apiLicense = this.docket.info().license();
        ApiContact apiContact = this.docket.info().contact();
        this.swagger.setSwagger(this.docket.version());
        this.swagger.info(new Info().title(this.docket.info().title()).description(this.docket.info().description()).termsOfService(this.docket.info().termsOfService()).version(this.docket.info().version()));
        if (apiLicense != null) {
            License license = new License().url(apiLicense.url()).name(apiLicense.name());
            license.setVendorExtensions(apiLicense.vendorExtensions());
            this.swagger.getInfo().setLicense(license);
        }
        if (apiContact != null) {
            Contact contact = new Contact().email(apiContact.email()).name(apiContact.name()).url(apiContact.url());
            contact.setVendorExtensions(apiContact.vendorExtensions());
            this.swagger.getInfo().contact(contact);
        }
        this.swagger.host(BuilderHelper.getHost(this.docket));
        this.swagger.basePath(this.docket.basePath());
        if (this.docket.schemes() != null) {
            for (ApiScheme scheme : this.docket.schemes()) {
                this.swagger.scheme(Scheme.forValue((String)scheme.toValue()));
            }
        }
        if (this.docket.externalDocs() != null) {
            this.swagger.externalDocs(new ExternalDocs(this.docket.externalDocs().description(), this.docket.externalDocs().url()));
        }
        this.swagger.vendorExtensions(this.docket.vendorExtensions());
        if (this.swagger.getTags() != null) {
            this.swagger.getTags().sort((t1, t2) -> {
                String name1 = t1.getDescription();
                String name2 = t2.getDescription();
                return Collator.getInstance(Locale.UK).compare(name1, name2);
            });
        }
        if (this.swagger.getDefinitions() != null) {
            ArrayList definitionKeys = new ArrayList(this.swagger.getDefinitions().keySet());
            LinkedHashMap definitionMap = new LinkedHashMap();
            definitionKeys.sort((name1, name2) -> Collator.getInstance(Locale.UK).compare((String)name1, (String)name2));
            for (String name : definitionKeys) {
                definitionMap.put(name, this.swagger.getDefinitions().get(name));
            }
            this.swagger.setDefinitions(definitionMap);
        }
        return this.swagger;
    }

    private void parseGroupPackage() {
        Map<Class<?>, List<ActionHolder>> classMap = this.getApiAction();
        for (Map.Entry<Class<?>, List<ActionHolder>> kv : classMap.entrySet()) {
            this.parseController(kv.getKey(), kv.getValue());
        }
    }

    private Map<Class<?>, List<ActionHolder>> getApiAction() {
        HashMap apiMap = new HashMap(16);
        Collection routingCollection = Solon.app().router().getAll(Endpoint.main);
        for (Routing routing : routingCollection) {
            if (routing.target() instanceof Action) {
                this.resolveAction(apiMap, (Routing<Handler>)routing);
            }
            if (!(routing.target() instanceof Gateway)) continue;
            for (Routing routing2 : ((Gateway)routing.target()).getMainRouting().getAll()) {
                if (!(routing2.target() instanceof Action)) continue;
                this.resolveAction(apiMap, (Routing<Handler>)routing2);
            }
        }
        ArrayList ctlList = new ArrayList(apiMap.keySet());
        ctlList.sort(Comparator.comparingInt(clazz -> clazz.getAnnotation(Api.class).position()));
        LinkedHashMap result = new LinkedHashMap();
        ctlList.forEach(i -> {
            List actionHolders = (List)apiMap.get(i);
            actionHolders.sort(Comparator.comparingInt(ah -> ah.getAnnotation(ApiOperation.class).position()));
            result.put((Class<?>)i, actionHolders);
        });
        return result;
    }

    private void resolveAction(Map<Class<?>, List<ActionHolder>> apiMap, Routing<Handler> routing) {
        Action action = (Action)routing.target();
        Class controller = action.controller().clz();
        boolean matched = this.docket.apis().stream().anyMatch(res -> res.test(action));
        if (!matched) {
            return;
        }
        ActionHolder actionHolder = new ActionHolder(routing, action);
        if (apiMap.containsKey(controller)) {
            List<ActionHolder> actionHolders;
            if (action.method().isAnnotationPresent(ApiOperation.class) && !(actionHolders = apiMap.get(controller)).contains(actionHolder)) {
                actionHolders.add(actionHolder);
                apiMap.put(controller, actionHolders);
            }
        } else if (controller.isAnnotationPresent(Api.class) && action.method().isAnnotationPresent(ApiOperation.class)) {
            ArrayList<ActionHolder> actionHolders = new ArrayList<ActionHolder>();
            actionHolders.add(actionHolder);
            apiMap.put(controller, actionHolders);
        }
    }

    private void parseController(Class<?> clazz, List<ActionHolder> actionHolders) {
        Api api = clazz.getAnnotation(Api.class);
        boolean hidden = api.hidden();
        if (hidden) {
            return;
        }
        String controllerKey = BuilderHelper.getControllerKey(clazz);
        LinkedHashSet<String> apiTags = new LinkedHashSet<String>();
        apiTags.add(api.value());
        apiTags.addAll(Arrays.asList(api.tags()));
        apiTags.remove("");
        for (String tagName : apiTags) {
            Tag tag = new Tag();
            tag.setName(tagName);
            tag.setDescription(controllerKey + " (" + clazz.getSimpleName() + ")");
            this.swagger.addTag(tag);
        }
        this.parseAction(actionHolders);
    }

    private void parseAction(List<ActionHolder> actionHolders) {
        for (ActionHolder actionHolder : actionHolders) {
            ApiOperation apiAction = actionHolder.getAnnotation(ApiOperation.class);
            if (apiAction.hidden()) {
                return;
            }
            String controllerKey = BuilderHelper.getControllerKey(actionHolder.controllerClz());
            String actionName = actionHolder.action().name();
            Method actionMethod = actionHolder.action().method().getMethod();
            Set<String> actionTags = actionHolder.getTags(apiAction);
            String pathKey = actionHolder.routing().path();
            Path path = this.swagger.getPath(pathKey);
            if (path == null) {
                path = new Path();
                this.swagger.path(pathKey, path);
            }
            Operation operation = new Operation();
            operation.setTags(new ArrayList<String>(actionTags));
            operation.setSummary(apiAction.value());
            operation.setDescription(apiAction.notes());
            operation.setDeprecated(Boolean.valueOf(actionHolder.isAnnotationPresent(Deprecated.class)));
            String operationMethod = BuilderHelper.getHttpMethod(actionHolder, apiAction);
            operation.setParameters(this.parseActionParameters(actionHolder));
            operation.setResponses(this.parseActionResponse(controllerKey, actionName, actionMethod));
            operation.setVendorExtension("controllerKey", (Object)controllerKey);
            operation.setVendorExtension("actionName", (Object)actionName);
            if (Utils.isBlank((String)apiAction.consumes())) {
                if (operationMethod.equals("get")) {
                    operation.consumes("application/x-www-form-urlencoded");
                } else {
                    operation.consumes("application/x-www-form-urlencoded");
                }
            } else {
                operation.consumes(apiAction.consumes());
            }
            operation.produces(Utils.isBlank((String)apiAction.produces()) ? "*/*" : apiAction.produces());
            operation.setOperationId(operationMethod + "_" + pathKey.replace("/", "_"));
            path.set(operationMethod, operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Parameter> parseActionParameters(ActionHolder actionHolder) {
        LinkedHashMap<String, ParamHolder> actionParamMap = new LinkedHashMap<String, ParamHolder>();
        for (ParamWrap p1 : actionHolder.action().method().getParamWraps()) {
            actionParamMap.put(p1.getName(), new ParamHolder(p1));
        }
        ArrayList<ApiImplicitParam> apiParams = new ArrayList<ApiImplicitParam>();
        if (actionHolder.isAnnotationPresent(ApiImplicitParams.class)) {
            apiParams.addAll(Arrays.asList(actionHolder.getAnnotation(ApiImplicitParams.class).value()));
        }
        if (actionHolder.isAnnotationPresent(ApiImplicitParams.class)) {
            ApiImplicitParam[] paramArray = (ApiImplicitParam[])actionHolder.getAnnotationsByType(ApiImplicitParam.class);
            apiParams.addAll(Arrays.asList(paramArray));
        }
        for (ApiImplicitParam a1 : apiParams) {
            ParamHolder paramHolder = (ParamHolder)actionParamMap.get(a1.name());
            if (paramHolder == null) {
                paramHolder = new ParamHolder(null);
                actionParamMap.put(a1.name(), paramHolder);
            }
            paramHolder.binding(a1);
        }
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        Iterator<Object> iterator = actionParamMap.values().iterator();
        while (true) {
            HeaderParameter parameter;
            ParamHolder paramHolder;
            block28: {
                FormParameter formParameter;
                BodyParameter modelParameter;
                String dataType;
                String paramSchema;
                block29: {
                    if (!iterator.hasNext()) {
                        return paramList;
                    }
                    paramHolder = (ParamHolder)iterator.next();
                    if (paramHolder.isIgnore()) continue;
                    paramSchema = this.getParameterSchema(paramHolder);
                    dataType = paramHolder.dataType();
                    if (!paramHolder.allowMultiple()) break block29;
                    if (Utils.isNotEmpty((String)paramSchema)) {
                        modelParameter = new BodyParameter();
                        modelParameter.setSchema((Model)new ArrayModel().items((Property)new RefProperty(paramSchema)));
                        if (paramHolder.getParam() != null && !paramHolder.getParam().isRequiredBody()) {
                            modelParameter.setIn("query");
                        }
                        parameter = modelParameter;
                        break block28;
                    } else if ("file".equals(dataType)) {
                        formParameter = new FormParameter();
                        formParameter.type("array");
                        formParameter.items((Property)new FileProperty());
                        parameter = formParameter;
                        break block28;
                    } else {
                        ObjectProperty objectProperty = new ObjectProperty();
                        objectProperty.setType(dataType);
                        QueryParameter queryParameter = new QueryParameter();
                        queryParameter.type("array");
                        queryParameter.items((Property)objectProperty);
                        parameter = queryParameter;
                    }
                    break block28;
                }
                if (Utils.isNotEmpty((String)paramSchema)) {
                    if (paramHolder.isRequiredBody() || paramHolder.getParam() == null) {
                        modelParameter = new BodyParameter();
                        if (paramHolder.isMap()) {
                            modelParameter.setSchema((Model)new ModelImpl().type("object"));
                        } else {
                            modelParameter.setSchema((Model)new RefModel(paramSchema));
                        }
                        if (paramHolder.getParam() != null && !paramHolder.getParam().isRequiredBody()) {
                            modelParameter.setIn("query");
                        }
                        parameter = modelParameter;
                        break block28;
                    } else {
                        this.parseActionParametersByFields(paramHolder, paramList);
                        continue;
                    }
                }
                if ("file".equals(dataType)) {
                    formParameter = new FormParameter();
                    formParameter.items((Property)new FileProperty());
                    parameter = formParameter;
                } else if (paramHolder.isRequiredHeader()) {
                    parameter = new HeaderParameter();
                } else if (paramHolder.isRequiredCookie()) {
                    parameter = new CookieParameter();
                } else if (paramHolder.isRequiredPath()) {
                    parameter = new PathParameter();
                } else {
                    QueryParameter queryParameter = new QueryParameter();
                    queryParameter.setType(dataType);
                    if (paramHolder.getAnno() != null) {
                        queryParameter.setFormat(paramHolder.getAnno().format());
                        queryParameter.setDefaultValue(paramHolder.getAnno().defaultValue());
                    }
                    parameter = queryParameter;
                }
            }
            parameter.setName(paramHolder.getName());
            parameter.setDescription(paramHolder.getDescription());
            parameter.setRequired(paramHolder.isRequired());
            parameter.setReadOnly(Boolean.valueOf(paramHolder.isReadOnly()));
            if (Utils.isEmpty((String)parameter.getIn())) {
                parameter.setIn(paramHolder.paramType());
            }
            paramList.add((Parameter)parameter);
        }
    }

    private void parseActionParametersByFields(ParamHolder paramHolder, List<Parameter> paramList) {
        ClassWrap classWrap = ClassWrap.get((Class)paramHolder.getParam().getType());
        for (FieldWrap fw : classWrap.getFieldAllWraps().values()) {
            if (Modifier.isTransient(fw.field.getModifiers())) continue;
            QueryParameter parameter = new QueryParameter();
            parameter.setType(fw.type.getSimpleName());
            ApiModelProperty anno = fw.field.getAnnotation(ApiModelProperty.class);
            if (anno != null) {
                parameter.setName(anno.name());
                parameter.setDescription(anno.value());
                parameter.setRequired(anno.required());
                parameter.setReadOnly(Boolean.valueOf(anno.readOnly()));
                if (Utils.isNotEmpty((String)anno.dataType())) {
                    parameter.setType(anno.dataType());
                }
            }
            if (Utils.isEmpty((String)parameter.getName())) {
                parameter.setName(fw.field.getName());
            }
            paramList.add((Parameter)parameter);
        }
    }

    private Map<String, Response> parseActionResponse(String controllerKey, String actionName, Method method) {
        LinkedHashMap<String, Response> responseMap = new LinkedHashMap<String, Response>();
        this.docket.globalResponseCodes().forEach((key, value) -> {
            String schema;
            Response response = new Response();
            response.description(value);
            if (key == 200 && (schema = this.parseResponse(controllerKey, actionName, method)) != null) {
                response.setResponseSchema((Model)new RefModel(schema));
            }
            responseMap.put(String.valueOf(key), response);
        });
        return responseMap;
    }

    private String parseResponse(String controllerKey, String actionName, Method method) {
        Class<?> apiResClz;
        String swaggerModelName = null;
        ArrayList<ApiResProperty> responses = new ArrayList<ApiResProperty>();
        if (method.isAnnotationPresent(ApiRes.class)) {
            responses.addAll(Arrays.asList(method.getAnnotation(ApiRes.class).value()));
        }
        if (method.isAnnotationPresent(ApiRes.class)) {
            ApiResProperty[] paramArray = (ApiResProperty[])method.getAnnotationsByType(ApiResProperty.class);
            responses.addAll(Arrays.asList(paramArray));
        }
        if ((apiResClz = method.getReturnType()) != Void.class && BuilderHelper.isModel(apiResClz)) {
            try {
                ModelImpl commonResKv = (ModelImpl)this.parseSwaggerModel(apiResClz, method.getGenericReturnType());
                swaggerModelName = commonResKv.getName();
                return swaggerModelName;
            }
            catch (Exception e) {
                String hint = method.getDeclaringClass().getName() + ":" + method.getName() + "->" + apiResClz.getSimpleName();
                throw new DocException("Response model parsing failure: " + hint, (Throwable)e);
            }
        }
        if (responses.size() == 0) {
            if (this.globalResultModel != null) {
                swaggerModelName = this.globalResultModel.getName();
            }
        } else {
            ModelImpl swaggerModelKv = (ModelImpl)this.parseSwaggerModel(controllerKey, actionName, responses);
            swaggerModelName = swaggerModelKv.getName();
            if (this.docket.globalResponseInData()) {
                swaggerModelName = this.toResponseInData(swaggerModelName);
            }
        }
        return swaggerModelName;
    }

    private String toResponseInData(String swaggerModelName) {
        if (this.globalResultModel != null) {
            LinkedHashMap<String, RefProperty> propertyMap = new LinkedHashMap<String, RefProperty>();
            propertyMap.putAll(this.globalResultModel.getProperties());
            RefProperty property = new RefProperty(swaggerModelName, RefFormat.INTERNAL);
            property.setDescription("\u8fd4\u56de\u503c");
            propertyMap.put("data", property);
            swaggerModelName = this.globalResultModel.getName() + "\u00ab" + swaggerModelName + "\u00bb";
            ModelImpl model = new ModelImpl();
            model.setTitle(swaggerModelName);
            model.setProperties(propertyMap);
            this.swagger.addDefinition(swaggerModelName, (Model)model);
        }
        return swaggerModelName;
    }

    private Model parseSwaggerModel(Class<?> clazz, Type type) {
        Field[] fields;
        Model model;
        String modelName = BuilderHelper.getModelName(clazz, type);
        if (this.swagger.getDefinitions() != null && null != (model = (Model)this.swagger.getDefinitions().get(modelName))) {
            return model;
        }
        ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
        String title = apiModel != null ? apiModel.description() : modelName;
        LinkedHashMap<String, Object> fieldList = new LinkedHashMap<String, Object>();
        ModelImpl model2 = new ModelImpl();
        model2.setName(modelName);
        model2.setTitle(title);
        model2.setType("object");
        this.swagger.addDefinition(modelName, (Model)model2);
        for (Field field : fields = clazz.getDeclaredFields()) {
            ObjectProperty fieldPr;
            if (Modifier.isStatic(field.getModifiers())) continue;
            ApiModelProperty apiField = field.getAnnotation(ApiModelProperty.class);
            Class typeClazz = field.getType();
            Type typeGenericType = field.getGenericType();
            if (typeGenericType instanceof TypeVariable && type instanceof ParameterizedType) {
                Map genericMap = GenericUtil.getGenericInfo((Type)type);
                Type typeClazz2 = (Type)genericMap.get(typeGenericType.getTypeName());
                if (typeClazz2 instanceof Class) {
                    typeClazz = (Class)typeClazz2;
                }
                if (typeClazz2 instanceof ParameterizedType) {
                    ParameterizedType typeGenericType2 = (ParameterizedType)typeClazz2;
                    typeClazz = (Class)typeGenericType2.getRawType();
                    typeGenericType = typeClazz2;
                }
            }
            if (Collection.class.isAssignableFrom(typeClazz)) {
                Map genericMap;
                Type itemClazz2;
                ParameterizedType pt;
                Type itemClazz;
                if (typeGenericType == null || !(typeGenericType instanceof ParameterizedType)) continue;
                fieldPr = new ArrayProperty();
                if (apiField != null) {
                    fieldPr.setDescription(apiField.value());
                }
                if ((itemClazz = (pt = (ParameterizedType)typeGenericType).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                    itemClazz = ((ParameterizedType)itemClazz).getRawType();
                }
                if (itemClazz instanceof TypeVariable && (itemClazz2 = (Type)(genericMap = GenericUtil.getGenericInfo((Type)type)).get(itemClazz.getTypeName())) instanceof Class) {
                    itemClazz = itemClazz2;
                }
                if (itemClazz instanceof Class) {
                    if (itemClazz.equals(type)) {
                        RefProperty itemPr = new RefProperty(modelName, RefFormat.INTERNAL);
                        fieldPr.setItems((Property)itemPr);
                    } else {
                        ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel((Class)itemClazz, itemClazz);
                        RefProperty itemPr = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                        fieldPr.setItems((Property)itemPr);
                    }
                }
                fieldList.put(field.getName(), fieldPr);
                continue;
            }
            if (BuilderHelper.isModel(typeClazz)) {
                if (typeClazz.equals(type)) {
                    fieldPr = new RefProperty(modelName, RefFormat.INTERNAL);
                    if (apiField != null) {
                        fieldPr.setDescription(apiField.value());
                    }
                    fieldList.put(field.getName(), fieldPr);
                    continue;
                }
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(typeClazz, typeGenericType);
                RefProperty fieldPr2 = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                if (apiField != null) {
                    fieldPr2.setDescription(apiField.value());
                }
                fieldList.put(field.getName(), fieldPr2);
                continue;
            }
            fieldPr = new ObjectProperty();
            fieldPr.setName(field.getName());
            if (apiField != null) {
                fieldPr.setDescription(apiField.value());
                fieldPr.setType(Utils.isBlank((String)apiField.dataType()) ? typeClazz.getSimpleName().toLowerCase() : apiField.dataType());
                fieldPr.setExample(apiField.example());
            } else {
                fieldPr.setType(typeClazz.getSimpleName().toLowerCase());
            }
            fieldList.put(field.getName(), fieldPr);
        }
        model2.setProperties(fieldList);
        return model2;
    }

    private Model parseSwaggerModel(String controllerKey, String actionName, List<ApiResProperty> responses) {
        String modelName = controllerKey + "_" + actionName;
        LinkedHashMap<String, ArrayProperty> propertiesList = new LinkedHashMap<String, ArrayProperty>();
        ModelImpl model = new ModelImpl();
        model.setName(modelName);
        this.swagger.addDefinition(modelName, (Model)model);
        if (!this.docket.globalResponseInData() && this.globalResultModel != null) {
            propertiesList.putAll(this.globalResultModel.getProperties());
        }
        for (ApiResProperty apiResponse : responses) {
            ArrayProperty fieldPr;
            if (apiResponse.dataTypeClass() != Void.class) {
                ArrayProperty fieldPr2;
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(apiResponse.dataTypeClass(), apiResponse.dataTypeClass());
                if (apiResponse.allowMultiple()) {
                    fieldPr2 = new ArrayProperty();
                    fieldPr2.setName(swaggerModel.getName());
                    fieldPr2.setDescription(apiResponse.value());
                    fieldPr2.items((Property)new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL));
                    propertiesList.put(apiResponse.name(), fieldPr2);
                    continue;
                }
                fieldPr2 = new RefProperty(swaggerModel.getName(), RefFormat.INTERNAL);
                fieldPr2.setDescription(apiResponse.value());
                propertiesList.put(apiResponse.name(), fieldPr2);
                continue;
            }
            if (apiResponse.allowMultiple()) {
                fieldPr = new ArrayProperty();
                fieldPr.setName(apiResponse.name());
                fieldPr.setDescription(apiResponse.value());
                fieldPr.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
                fieldPr.setExample(apiResponse.example());
                UntypedProperty itemsProperty = new UntypedProperty();
                itemsProperty.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
                fieldPr.items((Property)itemsProperty);
                propertiesList.put(apiResponse.name(), fieldPr);
                continue;
            }
            fieldPr = new UntypedProperty();
            fieldPr.setName(apiResponse.name());
            fieldPr.setDescription(apiResponse.value());
            fieldPr.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
            fieldPr.setFormat(Utils.isBlank((String)apiResponse.format()) ? "" : apiResponse.format());
            fieldPr.setExample(apiResponse.example());
            propertiesList.put(apiResponse.name(), fieldPr);
        }
        model.setProperties(propertiesList);
        return model;
    }

    private String getParameterSchema(ParamHolder paramHolder) {
        Class dataTypeClass;
        if (paramHolder.getAnno() != null && (dataTypeClass = paramHolder.getAnno().dataTypeClass()) != Void.class) {
            ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(dataTypeClass, dataTypeClass);
            return swaggerModel.getName();
        }
        if (paramHolder.getParam() != null) {
            dataTypeClass = paramHolder.getParam().getType();
            if (dataTypeClass.isPrimitive()) {
                return null;
            }
            if (UploadedFile.class.equals((Object)dataTypeClass)) {
                return null;
            }
            if (dataTypeClass.getName().startsWith("java.lang")) {
                return null;
            }
            Type dataGenericType = paramHolder.getParam().getGenericType();
            if (dataTypeClass != Void.class) {
                Type itemType;
                if (Collection.class.isAssignableFrom(dataTypeClass) && dataGenericType instanceof ParameterizedType && (itemType = ((ParameterizedType)dataGenericType).getActualTypeArguments()[0]) instanceof Class) {
                    ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel((Class)itemType, itemType);
                    return swaggerModel.getName();
                }
                ModelImpl swaggerModel = (ModelImpl)this.parseSwaggerModel(dataTypeClass, dataGenericType);
                return swaggerModel.getName();
            }
        }
        return null;
    }
}

