/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.solon;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;

public class ShardingSphereSupplier
implements Supplier<DataSource> {
    private Properties properties;

    public ShardingSphereSupplier(Properties properties) {
        this.properties = properties;
    }

    @Override
    public DataSource get() {
        try {
            String fileUri = this.properties.getProperty("file");
            if (Utils.isNotEmpty((String)fileUri)) {
                URL url = ResourceUtil.findResource((String)fileUri);
                return YamlShardingSphereDataSourceFactory.createDataSource((File)new File(url.getFile()));
            }
            String configTxt = this.properties.getProperty("config");
            if (Utils.isNotEmpty((String)configTxt)) {
                return YamlShardingSphereDataSourceFactory.createDataSource((byte[])configTxt.getBytes());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("The sharding sphere configuration failed", e);
        }
        throw new IllegalStateException("Invalid sharding sphere configuration");
    }
}

