/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.utils.LocalUtils;
import org.noear.solon.core.Props;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;

public class Instance
implements Serializable {
    private String service;
    private String host;
    private int port;
    private String address;
    private String serviceAndAddress;
    private String protocol;
    private transient String _uri;
    private double weight = 1.0;
    private Map<String, String> meta = new HashMap<String, String>();
    private List<String> tags;
    private static Instance local;
    private static Map<String, String> appMeta;
    private static List<String> appTags;

    public String service() {
        return this.service;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        if (this.address == null) {
            this.address = this.host + ":" + this.port;
        }
        return this.address;
    }

    public String serviceAndAddress() {
        if (this.serviceAndAddress == null) {
            this.serviceAndAddress = this.service() + "@" + this.address();
        }
        return this.serviceAndAddress;
    }

    public String protocol() {
        return this.protocol;
    }

    public Instance protocol(String protocol) {
        if (Utils.isNotEmpty((String)protocol)) {
            this.protocol = protocol;
            this._uri = null;
        }
        return this;
    }

    public String uri() {
        if (this._uri == null) {
            this._uri = Utils.isEmpty((String)this.protocol) ? "http://" + this.address() : this.protocol + "://" + this.address();
        }
        return this._uri;
    }

    public double weight() {
        return this.weight;
    }

    public Instance weight(double weight) {
        this.weight = weight;
        return this;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public Instance metaPut(String name, String value) {
        if (value != null) {
            this.meta.put(name, value);
        }
        return this;
    }

    public String metaGet(String name) {
        return this.meta.get(name);
    }

    public Instance metaPutAll(Map<String, String> map) {
        if (map != null) {
            this.meta.putAll(map);
            this.protocol(map.get("protocol"));
        }
        return this;
    }

    public Instance metaRemove(String name) {
        this.meta.remove(name);
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public Instance tagsAdd(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
        return this;
    }

    public Instance tagsAddAll(Collection<String> list) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(list);
        return this;
    }

    public Instance() {
    }

    public Instance(String service, String host, int port) {
        if (Utils.isEmpty((String)service)) {
            service = Solon.cfg().appName();
        }
        if (port < 0) {
            port = 0;
        }
        this.service = service;
        this.host = host;
        this.port = port;
    }

    public static Instance local() {
        if (local == null) {
            String _wrapHost = Solon.cfg().serverWrapHost(false);
            int _wrapPort = Solon.cfg().serverWrapPort(false);
            local = Instance.localNew((Signal)new SignalSim(Solon.cfg().appName(), _wrapHost, _wrapPort, "http", SignalType.HTTP));
        }
        return local;
    }

    public static Instance localNew(Signal signal) {
        Instance n1 = null;
        n1 = Utils.isEmpty((String)signal.host()) ? new Instance(signal.name(), LocalUtils.getLocalAddress(), signal.port()) : new Instance(signal.name(), signal.host(), signal.port());
        n1.protocol(signal.protocol());
        n1.metaPutAll(Instance.getAppMeta());
        n1.metaPutAll((Map<String, String>)Solon.cfg().argx());
        n1.metaRemove("server.port");
        n1.metaPut("protocol", signal.protocol());
        n1.tagsAdd("solon");
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            n1.tagsAdd(Solon.cfg().appGroup());
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            n1.tagsAdd(Solon.cfg().appName());
        }
        n1.tagsAddAll(Instance.getAppTags());
        return n1;
    }

    private static Map<String, String> getAppMeta() {
        if (appMeta == null) {
            appMeta = new LinkedHashMap<String, String>();
            Props metsProps = Solon.cfg().getProp("solon.app.meta");
            for (Map.Entry kv : metsProps.entrySet()) {
                if (!(kv.getKey() instanceof String) || !(kv.getValue() instanceof String)) continue;
                appMeta.put((String)kv.getKey(), (String)kv.getValue());
            }
        }
        return appMeta;
    }

    private static List<String> getAppTags() {
        if (appTags == null) {
            String tagsStr = Solon.cfg().get("solon.app.tags");
            appTags = Utils.isNotEmpty((String)tagsStr) ? Arrays.asList(tagsStr.split(",")) : new ArrayList<String>();
        }
        return appTags;
    }

    public String toString() {
        return "Instance{service='" + this.service + '\'' + ", protocol='" + this.protocol + '\'' + ", weight=" + this.weight + ", address='" + this.address() + '\'' + '}';
    }
}

