/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.PropUtil;

public class Config
implements Serializable {
    private String group;
    private String key;
    private String value;
    private long version;
    private transient Properties _props;

    public Config(String group, String key, String value, long version) {
        this.group = group;
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public Config updateValue(String value, long version) {
        this.value = value;
        this.version = version;
        this._props = null;
        return this;
    }

    public String group() {
        return this.group;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public Properties toProps() {
        if (this._props == null) {
            this._props = Utils.buildProperties((String)this.value);
            for (Map.Entry<Object, Object> kv : this._props.entrySet()) {
                if (!(kv.getValue() instanceof String)) continue;
                String tmpV = PropUtil.getByTml((Properties)Solon.cfg(), (Properties)this._props, (String)((String)kv.getValue()));
                if (tmpV == null) {
                    tmpV = (String)kv.getValue();
                }
                this._props.put(kv.getKey(), tmpV);
            }
        }
        return this._props;
    }

    public <T> T toBean(Class<T> clz) {
        Properties props = this.toProps();
        return (T)PropsConverter.global().convert(props, null, clz, clz);
    }

    public String toString() {
        return "Config{key='" + this.key + '\'' + ", group='" + this.group + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

