/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.service;

import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.utils.DiscoveryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudDiscoveryObserverEntity
implements CloudDiscoveryHandler {
    static final Logger log = LoggerFactory.getLogger(CloudDiscoveryObserverEntity.class);
    public final String group;
    public final String service;
    public final CloudDiscoveryHandler handler;

    public CloudDiscoveryObserverEntity(String group, String service, CloudDiscoveryHandler handler) {
        this.group = group;
        this.service = service;
        this.handler = handler;
    }

    @Override
    public void handle(Discovery discovery) {
        try {
            DiscoveryUtils.tryLoadAgent(discovery, this.group, this.service);
            this.handler.handle(discovery);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

