/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.model.EventObserver;

public class EventObserverMap {
    private final EventObserver topicObserver;
    private final Map<String, EventObserver> tagMap = new LinkedHashMap<String, EventObserver>();

    public EventObserverMap(EventObserver topicObserver) {
        this.topicObserver = topicObserver;
    }

    public EventObserver topicObserver() {
        return this.topicObserver;
    }

    public EventObserver tagObserver(String tag) {
        return this.tagMap.get(tag);
    }

    public EventObserver tagObserverIfAbsent(String tag, Function<String, EventObserver> mappingFunction) {
        return this.tagMap.computeIfAbsent(tag, mappingFunction);
    }

    public Collection<String> getTags() {
        return this.tagMap.keySet();
    }

    public Collection<String> getTagsByLevel(EventLevel eventLevel) {
        HashSet<String> tags = new HashSet<String>();
        for (Map.Entry<String, EventObserver> kv : this.tagMap.entrySet()) {
            if (kv.getValue().getLevel() != eventLevel) continue;
            tags.add(kv.getKey());
        }
        return tags;
    }
}

