/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.model.BreakerEntrySim;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.core.Props;

public abstract class CloudBreakerServiceLocalImpl
implements CloudBreakerService {
    static final String CONFIG_PREFIX = "solon.cloud.local.breaker";
    static final String CONFIG_DEF = "root";
    private Map<String, BreakerEntrySim> breakers = new HashMap<String, BreakerEntrySim>();
    private int rootValue = 0;

    public CloudBreakerServiceLocalImpl() {
        Props props = Solon.cfg().getProp(CONFIG_PREFIX);
        if (props.size() > 0) {
            this.rootValue = props.getInt(CONFIG_DEF, 0);
            for (Object k : props.keySet()) {
                String key2;
                int val2;
                if (!(k instanceof String) || (val2 = props.getInt(key2 = (String)k, 0)) <= 0) continue;
                this.breakers.put(key2, this.create(key2, val2));
            }
            Solon.cfg().onChange((key, val) -> {
                String name;
                BreakerEntrySim tmp;
                if (key.startsWith(CONFIG_PREFIX) && (tmp = this.breakers.get(name = key.substring(CONFIG_PREFIX.length() + 1))) != null) {
                    tmp.reset(Integer.parseInt(val));
                }
            });
        }
    }

    protected abstract BreakerEntrySim create(String var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCloseable entry(String breakerName) throws BreakerException {
        BreakerEntrySim tmp = this.breakers.get(breakerName);
        if (tmp == null && this.rootValue > 0) {
            Map<String, BreakerEntrySim> map = this.breakers;
            synchronized (map) {
                tmp = this.breakers.get(breakerName);
                if (tmp == null) {
                    tmp = this.create(breakerName, this.rootValue);
                    this.breakers.put(breakerName, tmp);
                }
            }
        }
        if (tmp == null) {
            throw new IllegalArgumentException("Missing breaker configuration: " + breakerName);
        }
        return tmp.enter();
    }
}

