/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.service;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.model.EventObserver;

public class CloudEventObserverManger {
    private static final String TAG_SPLIT_MARK = "@";
    private Map<String, EventObserver> topicObserverMap = new LinkedHashMap<String, EventObserver>();
    private Map<String, EventObserver> topicAndTagObserverMap = new LinkedHashMap<String, EventObserver>();
    private Map<String, Set<String>> topicTagsMap = new LinkedHashMap<String, Set<String>>();

    public int topicSize() {
        return this.topicObserverMap.size();
    }

    public Set<String> topicAll() {
        return this.topicObserverMap.keySet();
    }

    public Map<String, Set<String>> topicTags() {
        return this.topicTagsMap;
    }

    public CloudEventHandler getByTopic(String topic) {
        return this.topicObserverMap.get(topic);
    }

    public CloudEventHandler getByTopicAndTag(String topicAndTag) {
        return this.topicAndTagObserverMap.get(topicAndTag);
    }

    public CloudEventHandler getByTopicAndTag(String topic, String tag) {
        String topicAndTag = topic + TAG_SPLIT_MARK + tag;
        return this.getByTopicAndTag(topicAndTag);
    }

    public void add(String topic, EventLevel level, String group, String topicRaw, String tag, CloudEventHandler observer) {
        this.addTopicObserver(topic, level, group, topicRaw, tag, observer);
        this.addTopicAndTagObserver(topic, level, group, topicRaw, tag, observer);
        this.addTopicTags(topic, tag);
    }

    private void addTopicObserver(String topic, EventLevel level, String group, String topicRaw, String tag, CloudEventHandler observer) {
        EventObserver eventObserver = this.topicObserverMap.get(topic);
        if (eventObserver == null) {
            eventObserver = new EventObserver(level, group, topicRaw, tag);
            this.topicObserverMap.put(topic, eventObserver);
        }
        eventObserver.addHandler(observer);
    }

    private void addTopicAndTagObserver(String topic, EventLevel level, String group, String topicRaw, String tag, CloudEventHandler observer) {
        if (Utils.isEmpty((String)tag)) {
            return;
        }
        String topicAndTag = topic + TAG_SPLIT_MARK + tag;
        EventObserver eventObserver = this.topicAndTagObserverMap.get(topicAndTag);
        if (eventObserver == null) {
            eventObserver = new EventObserver(level, group, topicRaw, tag);
            this.topicAndTagObserverMap.put(topicAndTag, eventObserver);
        }
        eventObserver.addHandler(observer);
    }

    private void addTopicTags(String topic, String tag) {
        Set<String> tags = this.topicTagsMap.get(topic);
        if (tags == null) {
            tags = new HashSet<String>();
            this.topicTagsMap.put(topic, tags);
        }
        tags.add(tag);
    }
}

