/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.annotation.CloudJob;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Action;

public class CloudJobBeanExtractor
implements BeanExtractor<CloudJob> {
    private static final CloudJobBeanExtractor instance = new CloudJobBeanExtractor();

    public static CloudJobBeanExtractor getInstance() {
        return instance;
    }

    public void doExtract(BeanWrap bw, Method method, CloudJob anno) {
        if (CloudClient.job() == null) {
            throw new IllegalArgumentException("Missing CloudJobService component");
        }
        String name = Solon.cfg().getByParse(anno.value());
        if (Utils.isEmpty((String)name)) {
            name = Solon.cfg().getByParse(anno.name());
        }
        String description = Solon.cfg().getByParse(anno.description());
        if (name.trim().length() == 0) {
            throw new IllegalStateException("CloudJob name invalid, for[" + bw.clz() + "#" + method.getName() + "] .");
        }
        if (CloudClient.job().isRegistered(name)) {
            throw new IllegalStateException("CloudJob[" + name + "] naming conflicts.");
        }
        Action action = new Action(bw, method);
        CloudClient.job().register(name, anno.cron7x(), description, arg_0 -> ((Action)action).handle(arg_0));
    }
}

