/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.core.handle.Result;

public interface CloudFileService {
    default public String getText(String bucket, String key) throws CloudFileException {
        try {
            return Utils.transferToString((InputStream)this.getStream(bucket, key), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new CloudFileException(e);
        }
    }

    default public String getText(String key) throws CloudFileException {
        return this.getText(null, key);
    }

    default public Result putText(String bucket, String key, String text) throws CloudFileException {
        ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        return this.putStream(bucket, key, stream, null);
    }

    default public Result putText(String key, String text) throws CloudFileException {
        return this.putText(null, key, text);
    }

    public InputStream getStream(String var1, String var2) throws CloudFileException;

    default public InputStream getStream(String key) throws CloudFileException {
        return this.getStream(null, key);
    }

    public Result putStream(String var1, String var2, InputStream var3, String var4) throws CloudFileException;

    default public Result putStream(String key, InputStream stream, String streamMime) throws CloudFileException {
        return this.putStream(null, key, stream, streamMime);
    }

    public Result delete(String var1, String var2) throws CloudFileException;

    default public Result delete(String key) {
        return this.delete(null, key);
    }
}

