/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudIdService;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.Signal;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.util.PrintUtil;

public class CloudClient {
    @Note(value="\u65ad\u8def\u5668\u670d\u52a1")
    public static CloudBreakerService breaker() {
        return CloudManager.breakerService();
    }

    @Note(value="\u914d\u7f6e\u670d\u52a1")
    public static CloudConfigService config() {
        return CloudManager.configService();
    }

    @Note(value="\u914d\u7f6e\u670d\u52a1\uff0c\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e")
    public static void configLoad(String group, String key) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)key)) {
            Config config = CloudClient.config().pull(group, key);
            if (config != null && Utils.isNotEmpty((String)config.value())) {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            }
            CloudClient.config().attention(group, key, cfg -> {
                Properties properties = config.toProps();
                Solon.cfg().loadAdd(properties);
            });
        }
    }

    @Note(value="\u914d\u7f6e\u670d\u52a1\uff0c\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u3002g::k,k")
    public static void configLoad(String groupKeySet) {
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)groupKeySet)) {
            String[] gkAry;
            for (String gkStr : gkAry = groupKeySet.split(",")) {
                String[] gk = gkStr.split("::");
                if (gk.length == 2) {
                    CloudClient.configLoad(gk[0], gk[1]);
                    continue;
                }
                CloudClient.configLoad(Solon.cfg().appGroup(), gk[0]);
            }
        }
    }

    @Note(value="\u53d1\u73b0\u670d\u52a1")
    public static CloudDiscoveryService discovery() {
        return CloudManager.discoveryService();
    }

    @Note(value="\u53d1\u73b0\u670d\u52a1\uff0c\u63a8\u9001\u672c\u5730\u670d\u52a1\uff08\u5373\u6ce8\u518c\uff09")
    public static void discoveryPush() {
        if (CloudClient.discovery() == null) {
            return;
        }
        if (Utils.isEmpty((String)Solon.cfg().appName())) {
            return;
        }
        Solon.global().onEvent(AppLoadEndEvent.class, event -> {
            for (Signal signal : Solon.global().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
                PrintUtil.info((String)"Cloud", (Object)("Service registered " + instance.service() + "@" + instance.uri()));
            }
        });
        Solon.global().onEvent(Signal.class, signal -> {
            Instance instance = Instance.localNew(signal);
            CloudClient.discovery().register(Solon.cfg().appGroup(), instance);
            PrintUtil.info((String)"Cloud", (Object)("Service registered " + instance.service() + "@" + instance.uri()));
        });
    }

    @Note(value="\u4e8b\u4ef6\u670d\u52a1")
    public static CloudEventService event() {
        return CloudManager.eventService();
    }

    @Note(value="\u9501\u670d\u52a1")
    public static CloudLockService lock() {
        return CloudManager.lockService();
    }

    @Note(value="\u65e5\u5fd7\u670d\u52a1")
    public static CloudLogService log() {
        return CloudManager.logService();
    }

    @Note(value="\u94fe\u8def\u8ddf\u8e2a\u670d\u52a1")
    public static CloudTraceService trace() {
        return CloudManager.traceService();
    }

    @Note(value="\u5ea6\u91cf\u670d\u52a1")
    public static CloudMetricService metric() {
        return CloudManager.metricService();
    }

    @Note(value="\u540d\u5355\u670d\u52a1")
    public static CloudListService list() {
        return CloudManager.listService();
    }

    @Note(value="\u6587\u4ef6\u670d\u52a1")
    public static CloudFileService file() {
        return CloudManager.fileService();
    }

    @Note(value="ID\u670d\u52a1")
    public static CloudIdService idService(String group, String service) {
        return CloudManager.idServiceFactory().create(group, service);
    }

    @Note(value="ID\u670d\u52a1")
    public static CloudIdService id() {
        return CloudManager.idServiceDef();
    }

    @Note(value="Job\u670d\u52a1")
    public static CloudJobService job() {
        return CloudManager.jobService();
    }
}

