/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.impl.CloudEventManager;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudIdService;
import org.noear.solon.cloud.service.CloudIdServiceFactory;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.util.PrintUtil;

public class CloudManager {
    private static CloudDiscoveryService discoveryService;
    private static CloudConfigService configService;
    private static CloudEventManager eventServiceManager;
    private static CloudLockService lockService;
    private static CloudLogService logService;
    private static CloudListService listService;
    private static CloudFileService fileService;
    private static CloudBreakerService breakerService;
    private static CloudTraceService traceService;
    private static CloudJobService jobService;
    private static CloudIdServiceFactory idServiceFactory;
    private static CloudIdService idServiceDef;
    protected static final Map<CloudConfig, CloudConfigHandler> configHandlerMap;
    protected static final Map<CloudEvent, CloudEventHandler> eventHandlerMap;

    public static void register(CloudConfig anno, CloudConfigHandler handler) {
        configHandlerMap.put(anno, handler);
    }

    public static void register(CloudEvent anno, CloudEventHandler handler) {
        eventHandlerMap.put(anno, handler);
    }

    public static void register(CloudBreakerService service) {
        breakerService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudBreakerService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudConfigService service) {
        configService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudConfigService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudDiscoveryService service) {
        discoveryService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudDiscoveryService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(String channel, CloudEventService service) {
        eventServiceManager.register(channel, service);
        if (Utils.isEmpty((String)channel)) {
            PrintUtil.info((String)"Cloud", (Object)("CloudEventService registered from the " + service.getClass().getTypeName()));
        } else {
            PrintUtil.info((String)"Cloud", (Object)("CloudEventService registered from the " + service.getClass().getTypeName() + " as &" + channel));
        }
    }

    public static void register(CloudLockService service) {
        lockService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudLockService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudLogService service) {
        logService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudLogService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudListService service) {
        listService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudListService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudFileService service) {
        fileService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudFileService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudTraceService service) {
        traceService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudTraceService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudJobService service) {
        jobService = service;
        PrintUtil.info((String)"Cloud", (Object)("CloudJobService registered from the " + service.getClass().getTypeName()));
    }

    public static void register(CloudIdServiceFactory factory) {
        idServiceFactory = factory;
        idServiceDef = factory.create();
        PrintUtil.info((String)"Cloud", (Object)("CloudIdServiceFactory registered from the " + factory.getClass().getTypeName()));
    }

    protected static CloudBreakerService breakerService() {
        return breakerService;
    }

    protected static CloudConfigService configService() {
        return configService;
    }

    protected static CloudDiscoveryService discoveryService() {
        return discoveryService;
    }

    protected static CloudEventService eventService() {
        return eventServiceManager;
    }

    protected static CloudLockService lockService() {
        return lockService;
    }

    protected static CloudLogService logService() {
        return logService;
    }

    protected static CloudListService listService() {
        return listService;
    }

    protected static CloudFileService fileService() {
        return fileService;
    }

    protected static CloudTraceService traceService() {
        return traceService;
    }

    protected static CloudIdServiceFactory idServiceFactory() {
        return idServiceFactory;
    }

    protected static CloudIdService idServiceDef() {
        return idServiceDef;
    }

    protected static CloudJobService jobService() {
        return jobService;
    }

    static {
        eventServiceManager = new CloudEventManager();
        configHandlerMap = new LinkedHashMap<CloudConfig, CloudConfigHandler>();
        eventHandlerMap = new LinkedHashMap<CloudEvent, CloudEventHandler>();
    }
}

