/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.Props;

public class CloudDiscoveryServiceLocalImp
implements CloudDiscoveryService {
    List<Instance> instanceList = new ArrayList<Instance>();

    public CloudDiscoveryServiceLocalImp() {
        Props props = Solon.cfg().getProp("solon.cloud.local.discovery.service");
        if (props.size() > 0) {
            props.forEach((k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String key = ((String)k).split("\\[")[0];
                    URI val = URI.create((String)v);
                    this.instanceList.add(new Instance(key, val.getAuthority()).protocol(val.getScheme()));
                }
            });
        }
    }

    @Override
    public void register(String group, Instance instance) {
        this.instanceList.add(instance);
    }

    @Override
    public void registerState(String group, Instance instance, boolean health) {
    }

    @Override
    public void deregister(String group, Instance instance) {
    }

    @Override
    public Discovery find(String group, String service) {
        Discovery discovery = new Discovery(service);
        for (Instance n : this.instanceList) {
            if (!service.equals(n.service())) continue;
            discovery.instanceAdd(n);
        }
        return discovery;
    }

    @Override
    public void attention(String group, String service, CloudDiscoveryHandler observer) {
    }
}

