/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Node;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.utils.LocalUtils;

public class CloudClient {
    public static CloudConfigService config() {
        return CloudManager.configService();
    }

    public static void configLoad(String group, String key) {
        Config config;
        if (CloudClient.config() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)key) && (config = CloudClient.config().get(group, key)) != null && Utils.isNotEmpty((String)config.value)) {
            Properties properties = Utils.buildProperties((String)config.value);
            Solon.cfg().loadAdd(properties);
        }
    }

    public static CloudDiscoveryService discovery() {
        return CloudManager.discoveryService();
    }

    public static void discoveryPush(String hostname) {
        if (CloudClient.discovery() == null) {
            return;
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            Node node = new Node();
            node.service = Solon.cfg().appName();
            node.port = Solon.global().port();
            node.protocol = "http";
            node.ip = Utils.isEmpty((String)hostname) ? LocalUtils.getLocalAddress() : hostname;
            CloudClient.discovery().register(node);
        }
    }

    public static CloudEventService event() {
        return CloudManager.eventService();
    }
}

