/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.integration;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.metrics.annotation.MeterCounter;
import org.noear.solon.cloud.metrics.annotation.MeterGauge;
import org.noear.solon.cloud.metrics.annotation.MeterLongTimer;
import org.noear.solon.cloud.metrics.annotation.MeterSummary;
import org.noear.solon.cloud.metrics.annotation.MeterTimer;
import org.noear.solon.cloud.metrics.export.MeterOpener;
import org.noear.solon.cloud.metrics.export.PrometheusOpener;
import org.noear.solon.cloud.metrics.integration.CloudMetricServiceImpl;
import org.noear.solon.cloud.metrics.integration.MetricsController;
import org.noear.solon.cloud.metrics.interceptor.MeterCounterInterceptor;
import org.noear.solon.cloud.metrics.interceptor.MeterGaugeInterceptor;
import org.noear.solon.cloud.metrics.interceptor.MeterLongTimerInterceptor;
import org.noear.solon.cloud.metrics.interceptor.MeterSummaryInterceptor;
import org.noear.solon.cloud.metrics.interceptor.MeterTimerInterceptor;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.MethodInterceptor;
import org.noear.solon.core.event.AppBeanLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;

public class XPluginImpl
implements Plugin {
    List<MeterOpener> meterOpeners = new ArrayList<MeterOpener>();

    public void start(AppContext context) {
        context.beanInterceptorAdd(MeterCounter.class, (MethodInterceptor)new MeterCounterInterceptor());
        context.beanInterceptorAdd(MeterGauge.class, (MethodInterceptor)new MeterGaugeInterceptor());
        context.beanInterceptorAdd(MeterSummary.class, (MethodInterceptor)new MeterSummaryInterceptor());
        context.beanInterceptorAdd(MeterTimer.class, (MethodInterceptor)new MeterTimerInterceptor());
        context.beanInterceptorAdd(MeterLongTimer.class, (MethodInterceptor)new MeterLongTimerInterceptor());
        context.subBeansOfType(MeterRegistry.class, registry -> {
            if (registry != Metrics.globalRegistry) {
                Metrics.addRegistry((MeterRegistry)registry);
            }
        });
        context.subBeansOfType(MeterBinder.class, binder -> binder.bindTo((MeterRegistry)Metrics.globalRegistry));
        context.wrapAndPut(MeterRegistry.class, (Object)Metrics.globalRegistry);
        Solon.app().add("/", MetricsController.class);
        this.forCommonTagsInit();
        this.forOpener(context);
        this.forCloudImpl();
    }

    private void forCloudImpl() {
        CloudManager.register((CloudMetricService)new CloudMetricServiceImpl());
    }

    private void forOpener(AppContext aopContext) {
        this.meterOpeners.add(new PrometheusOpener());
        aopContext.subBeansOfType(MeterOpener.class, bean -> this.meterOpeners.add((MeterOpener)bean));
        EventBus.subscribe(AppBeanLoadEndEvent.class, e -> {
            for (MeterOpener adapter : this.meterOpeners) {
                if (!adapter.isSupported(aopContext)) continue;
                Solon.app().get(adapter.path(), (Handler)adapter);
            }
        });
    }

    private void forCommonTagsInit() {
        ArrayList<Tag> commonTags = new ArrayList<Tag>();
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            commonTags.add(Tag.of((String)"solon.app.name", (String)Solon.cfg().appName()));
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            commonTags.add(Tag.of((String)"solon.app.group", (String)Solon.cfg().appGroup()));
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appNamespace())) {
            commonTags.add(Tag.of((String)"solon.app.nameSpace", (String)Solon.cfg().appNamespace()));
        }
        if (commonTags.size() > 0) {
            Metrics.globalRegistry.config().commonTags(commonTags);
        }
    }

    public void stop() throws Throwable {
        for (MeterRegistry registry : Metrics.globalRegistry.getRegistries()) {
            registry.close();
        }
    }
}

