/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.integration;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Mapping;

public class MetricsController {
    @Mapping(value="/metrics/registrys")
    public Map<String, List<?>> registrys() {
        HashMap data = new HashMap();
        ArrayList<String> registrys = new ArrayList<String>();
        for (MeterRegistry meterRegistry : Metrics.globalRegistry.getRegistries()) {
            registrys.add(meterRegistry.getClass().getName());
        }
        data.put("_registrys", registrys);
        return data;
    }

    @Mapping(value="/metrics/meters")
    public Map<String, List<?>> meters() {
        HashMap data = new HashMap();
        ArrayList meters = new ArrayList();
        Metrics.globalRegistry.getMeters().forEach(meter -> meters.add(meter.getId().getName()));
        data.put("_meters", meters);
        return data;
    }

    @Mapping(value="/metrics/meter/{meterName}")
    public Map<String, Object> meter(String meterName) {
        LinkedHashMap<String, Object> meterData = new LinkedHashMap<String, Object>();
        meterData.put("name", meterName);
        for (Meter meter : Metrics.globalRegistry.getMeters()) {
            if (!meterName.equals(meter.getId().getName())) continue;
            meterData.put("description", meter.getId().getDescription());
            meterData.put("baseUnit", meter.getId().getBaseUnit());
            LinkedHashMap<String, Double> measurements = new LinkedHashMap<String, Double>();
            for (Measurement measure : meter.measure()) {
                measurements.put(measure.getStatistic().name(), measure.getValue());
            }
            meterData.put("measurements", measurements);
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            for (Tag tag : meter.getId().getTags()) {
                tags.put(tag.getKey(), tag.getValue());
            }
            meterData.put("tags", tags);
            break;
        }
        return meterData;
    }
}

