/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExNewRequest;
import org.noear.solon.cloud.gateway.exchange.ExNewResponse;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.cloud.gateway.route.Route;

public class ExContextImpl
implements ExContext {
    private final Map<String, Object> attrMap;
    private final HttpServerRequest rawRequest;
    private ExNewRequest newRequest;
    private ExNewResponse newResponse;
    private Route route;
    private String realIp;
    private URI rawURI;

    public ExContextImpl(HttpServerRequest rawRequest) {
        this.rawRequest = rawRequest;
        this.attrMap = new HashMap<String, Object>();
    }

    @Override
    public <T> T attr(String key) {
        return (T)this.attrMap.get(key);
    }

    @Override
    public void attrSet(String key, Object value) {
        this.attrMap.put(key, value);
    }

    public void bind(Route route) {
        if (route != null) {
            this.route = route;
        }
    }

    public Route route() {
        return this.route;
    }

    @Override
    public URI target() {
        if (this.route == null) {
            return null;
        }
        return this.route.getTarget();
    }

    @Override
    public TimeoutProperties timeout() {
        if (this.route == null) {
            return null;
        }
        return this.route.getTimeout();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.rawRequest.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.rawRequest.localAddress();
    }

    @Override
    public String realIp() {
        if (this.realIp == null) {
            this.realIp = this.rawHeader("X-Real-IP");
            if (Utils.isEmpty((String)this.realIp) || "unknown".equalsIgnoreCase(this.realIp)) {
                this.realIp = this.rawHeader("X-Forwarded-For");
                if (this.realIp != null && this.realIp.contains(",")) {
                    this.realIp = this.realIp.split(",")[0];
                }
            }
            if (Utils.isEmpty((String)this.realIp) || "unknown".equalsIgnoreCase(this.realIp)) {
                this.realIp = this.remoteAddress().host();
            }
        }
        return this.realIp;
    }

    @Override
    public boolean isSecure() {
        return this.rawRequest.isSSL();
    }

    @Override
    public String rawMethod() {
        return this.rawRequest.method().name();
    }

    @Override
    public URI rawURI() {
        if (this.rawURI == null) {
            this.rawURI = URI.create(this.rawRequest.absoluteURI());
        }
        return this.rawURI;
    }

    @Override
    public String rawPath() {
        return this.rawRequest.path();
    }

    @Override
    public String rawQueryString() {
        return this.rawRequest.query();
    }

    @Override
    public String rawQueryParam(String key) {
        return this.rawRequest.getParam(key);
    }

    @Override
    public MultiMap rawQueryParams() {
        return this.rawRequest.params();
    }

    @Override
    public String rawHeader(String key) {
        return this.rawRequest.getHeader(key);
    }

    @Override
    public MultiMap rawHeaders() {
        return this.rawRequest.headers();
    }

    @Override
    public String rawCookie(String key) {
        Cookie cookie = this.rawRequest.getCookie(key);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public Set<Cookie> rawCookies() {
        return this.rawRequest.cookies();
    }

    @Override
    public ExNewRequest newRequest() {
        if (this.newRequest == null) {
            this.newRequest = new ExNewRequest();
            this.newRequest.method(this.rawRequest.method().name());
            this.newRequest.queryString(this.rawRequest.query());
            this.newRequest.path(this.rawRequest.path());
            for (Map.Entry kv : this.rawRequest.headers().entries()) {
                this.newRequest.headerAdd((String)kv.getKey(), (String)kv.getValue());
            }
            this.newRequest.body((ReadStream<Buffer>)this.rawRequest);
        }
        return this.newRequest;
    }

    @Override
    public ExNewResponse newResponse() {
        if (this.newResponse == null) {
            this.newResponse = new ExNewResponse();
        }
        return this.newResponse;
    }
}

