/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.integration;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.cloud.gateway.CloudGateway;
import org.noear.solon.cloud.gateway.CloudGatewayFilter;
import org.noear.solon.cloud.gateway.CloudRouteHandler;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.integration.GatewayLocator;
import org.noear.solon.cloud.gateway.integration.GatewayServerProps;
import org.noear.solon.cloud.gateway.properties.GatewayProperties;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.LogUtil;

public class XPluginImpl
implements Plugin {
    private static final String SOLON_CLOUD_GATEWAY = "solon.cloud.gateway";
    private static Signal _signal;
    private Vertx _vertx;
    private HttpServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "vert.x 4.5/ " + Solon.version();
    }

    public void start(AppContext context) throws Throwable {
        Props gatewayProps = context.cfg().getProp(SOLON_CLOUD_GATEWAY);
        GatewayProperties gatewayProperties = gatewayProps.size() > 0 ? (GatewayProperties)gatewayProps.getBean(GatewayProperties.class) : new GatewayProperties();
        this._vertx = Vertx.vertx();
        context.wrapAndPut(Vertx.class, (Object)this._vertx);
        CloudGateway cloudGateway = new CloudGateway();
        if (Utils.isNotEmpty(gatewayProperties.getDefaultFilters())) {
            for (String defaultFilter : gatewayProperties.getDefaultFilters()) {
                cloudGateway.getConfiguration().routeDefaultFilter(RouteFactoryManager.buildFilter(defaultFilter));
            }
        }
        context.wrapAndPut(CloudRouteRegister.class, (Object)cloudGateway.getConfiguration());
        context.subWrapsOfType(CloudGatewayFilter.class, bw -> cloudGateway.getConfiguration().filter((ExFilter)bw.raw(), bw.index()));
        context.getBeanAsync(CloudRouteHandler.class, b -> cloudGateway.getConfiguration().routeHandler((CloudRouteHandler)b));
        context.subBeansOfType(RouteFilterFactory.class, b -> RouteFactoryManager.addFactory(b));
        context.subBeansOfType(RoutePredicateFactory.class, b -> RouteFactoryManager.addFactory(b));
        GatewayLocator gatewayLocator = new GatewayLocator(gatewayProperties, cloudGateway.getConfiguration());
        context.lifecycle(-1, (LifecycleBean)gatewayLocator);
        context.lifecycle(99, () -> this.start0(cloudGateway));
    }

    private void start0(CloudGateway cloudGateway) {
        ServerProps.init();
        GatewayServerProps props = new GatewayServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = this._vertx.createHttpServer();
        this._server.requestHandler((Handler)cloudGateway);
        if (Utils.isNotEmpty((String)_host)) {
            this._server.listen(_port, _host);
        } else {
            this._server.listen(_port);
        }
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        Solon.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String httpServerUrl = props.buildHttpServerUrl(false);
        LogUtil.global().info("Connector:main: cloud.gateway: Started ServerConnector@{HTTP/1.1,[http/1.1]}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: cloud.gateway: Started (" + XPluginImpl.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }
}

