/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.util.KeyValues;

public class ExNewRequest {
    private String method;
    private String queryString;
    private String path;
    private Map<String, KeyValues<String>> headers = new LinkedHashMap<String, KeyValues<String>>();
    private Future<Buffer> body;

    public ExNewRequest method(String method) {
        this.method = method;
        return this;
    }

    public ExNewRequest path(String path) {
        this.path = path;
        return this;
    }

    public ExNewRequest queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    private KeyValues<String> getHeaderHolder(String key) {
        return this.headers.computeIfAbsent(key, k -> new KeyValues(key));
    }

    public ExNewRequest header(String key, String ... values) {
        this.getHeaderHolder(key).setValues((Object[])values);
        return this;
    }

    public ExNewRequest header(String key, List<String> values) {
        this.getHeaderHolder(key).setValues((Object[])values.toArray(new String[values.size()]));
        return this;
    }

    public ExNewRequest headerAdd(String key, String value) {
        this.getHeaderHolder(key).addValue((Object)value);
        return this;
    }

    public ExNewRequest body(Future<Buffer> body) {
        this.body = body;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathAndQueryString() {
        if (Utils.isEmpty((String)this.queryString)) {
            return this.path;
        }
        return this.path + "?" + this.queryString;
    }

    public Map<String, KeyValues<String>> getHeaders() {
        return this.headers;
    }

    public Future<Buffer> getBody() {
        return this.body;
    }
}

