/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import java.util.List;
import java.util.Map;
import org.noear.solon.cloud.gateway.CloudGatewayConfiguration;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.cloud.gateway.route.RouteRequest;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.web.reactive.RxCompletion;
import org.noear.solon.web.reactive.RxFilterChainImpl;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

public class CloudGateway
implements Handler {
    private CloudGatewayConfiguration configuration = new CloudGatewayConfiguration();

    public void handle(Context ctx) throws Throwable {
        ctx.asyncStart(-1L, null);
        new RxFilterChainImpl(this.configuration.filters, this::doHandle).doFilter(ctx).subscribe((Subscriber)new RxCompletion(ctx));
    }

    private Mono<Void> doHandle(Context ctx) {
        Route route = this.findRoute(ctx);
        if (route == null) {
            ctx.status(404);
            return Mono.empty();
        }
        try {
            this.buildUpstreamRequest(ctx);
            return new RxFilterChainImpl(route.getFilters(), arg_0 -> ((RouteHandler)this.configuration.routeHandler).handle(arg_0)).doFilter(ctx);
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Mono.error((Throwable)ex);
            }
            return Mono.error((Throwable)new StatusException(ex, 400));
        }
    }

    private RouteRequest buildUpstreamRequest(Context ctx) throws Throwable {
        RouteRequest request = new RouteRequest();
        request.method(ctx.method());
        request.queryString(ctx.queryString());
        request.path(ctx.pathNew());
        for (Map.Entry kv : ctx.headersMap().entrySet()) {
            request.header((String)kv.getKey(), (List)kv.getValue());
        }
        request.body(ctx.bodyAsStream(), ctx.contentType());
        ctx.attrSet("cloud-upstream-request", (Object)request);
        return request;
    }

    private Route findRoute(Context ctx) {
        for (Route r : this.configuration.routes) {
            if (!r.matched(ctx)) continue;
            ctx.attrSet("cloud-route", (Object)r);
            return r;
        }
        return null;
    }

    public CloudGatewayConfiguration getConfiguration() {
        return this.configuration;
    }
}

