/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.cloud.gateway.exchange.ExNewRequest;
import org.noear.solon.cloud.gateway.exchange.ExNewResponse;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.cloud.gateway.route.Route;

public class ExContext {
    private final Map<String, Object> attrMap;
    private final HttpServerRequest rawRequest;
    private ExNewRequest newRequest;
    private ExNewResponse newResponse;
    private URI target;
    private TimeoutProperties timeout;

    public ExContext(HttpServerRequest rawRequest) {
        this.rawRequest = rawRequest;
        this.attrMap = new HashMap<String, Object>();
    }

    public <T> T attr(String key) {
        return (T)this.attrMap.get(key);
    }

    public void attrSet(String key, Object value) {
        this.attrMap.put(key, value);
    }

    public String rawPath() {
        return this.rawRequest.path();
    }

    public String rawHeader(String key) {
        return this.rawRequest.getHeader(key);
    }

    public String rawCookie(String key) {
        Cookie cookie = this.rawRequest.getCookie(key);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public void bind(Route route) {
        this.target = route.getTarget();
        this.timeout = route.getTimeout();
    }

    public URI target() {
        return this.target;
    }

    public TimeoutProperties timeout() {
        return this.timeout;
    }

    public ExNewRequest newRequest() {
        if (this.newRequest == null) {
            this.newRequest = new ExNewRequest();
            this.newRequest.method(this.rawRequest.method().name());
            this.newRequest.queryString(this.rawRequest.query());
            this.newRequest.path(this.rawRequest.path());
            for (Map.Entry kv : this.rawRequest.headers().entries()) {
                this.newRequest.headerAdd((String)kv.getKey(), (String)kv.getValue());
            }
            this.newRequest.body((Future<Buffer>)this.rawRequest.body());
        }
        return this.newRequest;
    }

    public ExNewResponse newResponse() {
        if (this.newResponse == null) {
            this.newResponse = new ExNewResponse();
        }
        return this.newResponse;
    }
}

