/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.cloud.gateway.route.RoutePredicate;
import org.noear.solon.cloud.gateway.route.redicate.PathPredicate;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.web.reactive.RxFilter;

public class Route {
    public static final String ATTR_NAME = "cloud-route";
    private String id;
    private URI target;
    private List<RoutePredicate> predicates = new ArrayList<RoutePredicate>();
    private List<RankEntity<RxFilter>> filters = new ArrayList<RankEntity<RxFilter>>();

    public static Route of(Context ctx) {
        return (Route)ctx.attr(ATTR_NAME);
    }

    public Route id(String id) {
        this.id = id;
        return this;
    }

    public Route target(URI uri) {
        this.target = uri;
        return this;
    }

    public Route target(String uri) {
        return this.target(URI.create(uri));
    }

    public Route filter(RxFilter filter) {
        return this.filter(filter, 0);
    }

    public Route filter(RxFilter filter, int index) {
        if (filter != null) {
            this.filters.add((RankEntity<RxFilter>)new RankEntity((Object)filter, index));
            this.filters.sort(Comparator.comparingInt(e -> e.index));
        }
        return this;
    }

    public Route predicate(RoutePredicate predicate) {
        if (predicate != null) {
            this.predicates.add(predicate);
        }
        return this;
    }

    public Route path(String path) {
        PathPredicate predicate = new PathPredicate();
        predicate.init(path);
        return this.predicate(predicate);
    }

    public boolean matched(Context ctx) {
        if (this.predicates.size() == 0) {
            return false;
        }
        for (Predicate predicate : this.predicates) {
            if (predicate.test(ctx)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public URI getTarget() {
        return this.target;
    }

    public List<RoutePredicate> getPredicates() {
        return this.predicates;
    }

    public List<RankEntity<RxFilter>> getFilters() {
        return this.filters;
    }
}

