/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.eventplus.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.eventplus.CloudEventSubscribe;
import org.noear.solon.cloud.eventplus.impl.CloudEventMethodProxy;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;

public class CloudEventSubscribeBeanExtractor
implements BeanExtractor<CloudEventSubscribe> {
    public void doExtract(BeanWrap bw, Method method, CloudEventSubscribe anno) {
        if (CloudClient.event() == null) {
            throw new IllegalArgumentException("Missing CloudEventService component");
        }
        Parameter[] args = method.getParameters();
        if (args.length != 1) {
            throw new IllegalArgumentException("Missing CloudEventSubscriber method need one parameter");
        }
        Class<?> entityClz = args[0].getType();
        CloudEvent anno2 = entityClz.getAnnotation(CloudEvent.class);
        if (anno2 == null) {
            throw new IllegalArgumentException("The entity is missing (@CloudEvent) annotations: " + this.getClass().getName());
        }
        String topic2 = Solon.cfg().getByParse(Utils.annoAlias((String)anno2.value(), (String)anno2.topic()));
        String group2 = Solon.cfg().getByParse(anno2.group());
        CloudEventMethodProxy hadnler2 = new CloudEventMethodProxy((BeanWrap)bw.raw(), method, entityClz);
        CloudManager.register((CloudEvent)anno2, (CloudEventHandler)hadnler2);
        CloudClient.event().attention(anno2.level(), anno2.channel(), group2, topic2, anno2.tag(), (CloudEventHandler)hadnler2);
    }
}

