/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.spymemcached;

import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.cache.CacheService;

public class MemCacheService
implements CacheService {
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected final MemcachedClient _cache;

    public MemCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public MemCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        if (defSeconds == 0 && !Utils.isEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 3) {
            this._defaultSeconds = 30;
        }
        if (Utils.isEmpty((String)this._cacheKeyHead)) {
            this._cacheKeyHead = Solon.cfg().appName();
        }
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
        builder.setProtocol(ConnectionFactoryBuilder.Protocol.BINARY);
        try {
            if (Utils.isNotEmpty((String)user) && Utils.isNotEmpty((String)password)) {
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(user, password));
                builder.setAuthDescriptor(ad);
            }
            this._cache = new MemcachedClient(builder.build(), AddrUtil.getAddresses((String)server));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                if (seconds > 0) {
                    this._cache.set(newKey, seconds, obj);
                } else {
                    this._cache.set(newKey, this._defaultSeconds, obj);
                }
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
            }
        }
    }

    public Object get(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                return this._cache.get(newKey);
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
                return null;
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            this._cache.delete(newKey);
        }
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + Utils.md5((String)key);
    }
}

