/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.redisson;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cache.redisson.RedissonBuilder;
import org.noear.solon.data.cache.CacheService;
import org.redisson.api.RedissonClient;

public class RedissonCacheService
implements CacheService {
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected final RedissonClient redissonClient;

    public RedissonCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedissonCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
        if (Utils.isEmpty((String)this._cacheKeyHead)) {
            this._cacheKeyHead = Solon.cfg().appName();
        }
        this.redissonClient = RedissonBuilder.build(prop);
    }

    public void store(String key, Object obj, int seconds) {
        this.redissonClient.getBucket(key).set(obj, (long)seconds, TimeUnit.SECONDS);
    }

    public Object get(String key) {
        return this.redissonClient.getBucket(key).get();
    }

    public void remove(String key) {
        this.redissonClient.getBucket(key).delete();
    }
}

