/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.jedis;

import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cache.jedis.JavabinSerializer;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.Serializer;

public class RedisCacheService
implements CacheService {
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected final RedisClient _redisClient;
    private Serializer<String> _serializer = null;

    public RedisCacheService serializer(Serializer<String> serializer) {
        if (serializer != null) {
            this._serializer = serializer;
        }
        return this;
    }

    public RedisCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedisCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String db_str = prop.getProperty("db");
        String maxTotaol_str = prop.getProperty("maxTotaol");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        int db = 0;
        int maxTotaol = 200;
        if (Utils.isNotEmpty((String)db_str)) {
            db = Integer.parseInt(db_str);
        }
        if (Utils.isNotEmpty((String)maxTotaol_str)) {
            maxTotaol = Integer.parseInt(maxTotaol_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
        if (Utils.isEmpty((String)this._cacheKeyHead)) {
            this._cacheKeyHead = Solon.cfg().appName();
        }
        this._redisClient = new RedisClient(prop, db, maxTotaol);
        this._serializer = JavabinSerializer.instance;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (this._redisClient != null) {
            String newKey = this.newKey(key);
            try {
                String val = (String)this._serializer.serialize(obj);
                if (seconds > 0) {
                    this._redisClient.open0(ru -> ru.key(newKey).expire(seconds).set(val));
                } else {
                    this._redisClient.open0(ru -> ru.key(newKey).expire(this._defaultSeconds).set(val));
                }
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
            }
        }
    }

    public Object get(String key) {
        if (this._redisClient != null) {
            String newKey = this.newKey(key);
            String val = (String)this._redisClient.open1(ru -> ru.key(newKey).get());
            if (val == null) {
                return null;
            }
            try {
                return this._serializer.deserialize((Object)val);
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
                return null;
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._redisClient != null) {
            String newKey = this.newKey(key);
            this._redisClient.open0(ru -> ru.key(newKey).delete());
        }
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + Utils.md5((String)key);
    }
}

