/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.java_websocket.WebSocket;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static final Map<WebSocket, Session> sessions = new HashMap<WebSocket, Session>();
    private final WebSocket real;
    private final String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(WebSocket real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            WebSocket webSocket = real;
            synchronized (webSocket) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(WebSocket real) {
        sessions.remove(real);
    }

    public _SocketServerSession(WebSocket real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.real.getResourceDescriptor());
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.uri().getPath();
        }
        return this._path;
    }

    public void sendAsync(String message) {
        this.send(message);
    }

    public void sendAsync(Message message) {
        this.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String message) {
        _SocketServerSession _SocketServerSession2 = this;
        synchronized (_SocketServerSession2) {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
                this.real.send(buf.array());
            } else {
                this.real.send(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        super.send(message);
        _SocketServerSession _SocketServerSession2 = this;
        synchronized (_SocketServerSession2) {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)message);
                this.real.send(buf.array());
            } else if (message.isString()) {
                this.real.send(message.bodyAsString());
            } else {
                byte[] bytes = message.body();
                this.real.send(bytes);
            }
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.real == null) {
            return;
        }
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.hasSSLSupport();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getLocalSocketAddress();
    }

    public void setAttachment(Object obj) {
        this.real.setAttachment(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttachment();
    }

    public Collection<Session> getOpenSessions() {
        return Collections.unmodifiableCollection(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

