/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.Solon;
import org.noear.solon.boot.websocket._SocketServerSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ListenerProxy;
import org.noear.solon.socketd.ProtocolManager;

public class WsServer
extends WebSocketServer {
    public WsServer(int port) {
        super(new InetSocketAddress(port));
    }

    public void onStart() {
        System.out.println("Solon.Server:Websocket onStart...");
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        ListenerProxy.getGlobal().onOpen(_SocketServerSession.get(conn));
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        ListenerProxy.getGlobal().onClose(_SocketServerSession.get(conn));
        _SocketServerSession.remove(conn);
    }

    public void onMessage(WebSocket conn, String data) {
        try {
            Session session = _SocketServerSession.get(conn);
            Message message = Message.wrap((String)conn.getResourceDescriptor(), null, (String)data);
            ListenerProxy.getGlobal().onMessage(session, message.isString(true));
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        try {
            Session session = _SocketServerSession.get(conn);
            Message message = null;
            message = Solon.global().enableWebSocketD() ? ProtocolManager.decode((ByteBuffer)data) : Message.wrap((String)conn.getResourceDescriptor(), null, (byte[])data.array());
            ListenerProxy.getGlobal().onMessage(session, message);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        ListenerProxy.getGlobal().onError(_SocketServerSession.get(conn), (Throwable)ex);
    }
}

