/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.boot.websocket.netty.WsServerHandler;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private ChannelHandlerContext real;

    public WebSocketImpl(ChannelHandlerContext real) {
        this.real = real;
        this.init(URI.create((String)real.attr(WsServerHandler.ResourceDescriptorKey).get()));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.channel().isOpen();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.real.channel().remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.real.channel().localAddress();
    }

    public void send(String text) {
        this.real.writeAndFlush((Object)new TextWebSocketFrame(text));
        this.onSend();
    }

    public void send(ByteBuffer binary) {
        this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)binary)));
        this.onSend();
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((ChannelHandlerContext)this.real).close());
    }
}

