/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IgnoreCaseMap;
import org.noear.solon.core.util.RunUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxHttpContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(VxHttpContext.class);
    private HttpServerRequest _request;
    private HttpServerResponse _response;
    private boolean _isAsync;
    private long _asyncTimeout = 30000L;
    private CompletableFuture<Object> _asyncFuture;
    private List<ContextAsyncListener> _asyncListeners = new ArrayList<ContextAsyncListener>();
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private int contentLength = -2;
    private InputStream bodyAsStream;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private Map<String, List<String>> _headersMap;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;

    protected HttpServerRequest innerGetRequest() {
        return this._request;
    }

    protected HttpServerResponse innerGetResponse() {
        return this._response;
    }

    protected boolean innerIsAsync() {
        return this._isAsync;
    }

    protected List<ContextAsyncListener> innerAsyncListeners() {
        return this._asyncListeners;
    }

    public VxHttpContext(HttpServerRequest request, HttpServerResponse response) {
        this._request = request;
        this._response = response;
        this._filesMap = new HashMap();
    }

    private void loadMultipartFormData() throws IOException {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            // empty if block
        }
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.remoteAddress().host();
    }

    public int remotePort() {
        return this._request.remoteAddress().port();
    }

    public String method() {
        return this._request.method().name();
    }

    public String protocol() {
        return "http";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return false;
    }

    public String url() {
        return this._request.absoluteURI();
    }

    public long contentLength() {
        if (this.contentLength > -2) {
            return this.contentLength;
        }
        String tmp = this._request.getHeader("Content-Length");
        this.contentLength = Utils.isEmpty((String)tmp) ? -1 : Integer.parseInt(tmp);
        return this.contentLength;
    }

    public String queryString() {
        return this._request.query();
    }

    public InputStream bodyAsStream() throws IOException {
        Buffer buffer;
        if (this.bodyAsStream != null) {
            return this.bodyAsStream;
        }
        CompletableFuture future = new CompletableFuture();
        this._request.body(r -> {
            if (r.succeeded()) {
                future.complete(r.result());
            } else {
                future.completeExceptionally(r.cause());
            }
        });
        try {
            buffer = (Buffer)future.get();
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        this.bodyAsStream = new ByteArrayInputStream(buffer.getBytes());
        return this.bodyAsStream;
    }

    public NvMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new NvMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry entry : this._request.params()) {
                    this._paramMap.put((String)entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : this._request.formAttributes()) {
                    this._paramMap.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (String name : this._request.params().names()) {
                    this._paramsMap.computeIfAbsent(name, k -> new ArrayList()).addAll(this._request.params().getAll(name));
                }
                for (String name : this._request.formAttributes().names()) {
                    this._paramsMap.computeIfAbsent(name, k -> new ArrayList()).addAll(this._request.formAttributes().getAll(name));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._paramsMap;
    }

    public Map<String, List<UploadedFile>> filesMap() throws IOException {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
            return this._filesMap;
        }
        return Collections.emptyMap();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new NvMap();
            for (Cookie c1 : this._request.cookies()) {
                this._cookieMap.put(c1.getName(), (Object)c1.getValue());
            }
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new NvMap();
            for (Map.Entry kv : this._request.headers()) {
                this._headerMap.put((String)kv.getKey(), kv.getValue());
            }
        }
        return this._headerMap;
    }

    public Map<String, List<String>> headersMap() {
        if (this._headersMap == null) {
            this._headersMap = new IgnoreCaseMap();
            for (String name : this._request.headers().names()) {
                this._headersMap.put(name, new ArrayList(this._request.headers().getAll(name)));
            }
        }
        return this._headersMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public void output(byte[] bytes) {
    }

    public void output(InputStream stream) {
    }

    public OutputStream outputStream() throws IOException {
        this._response.send();
        return null;
    }

    public void headerSet(String name, String val) {
    }

    public void headerAdd(String name, String val) {
    }

    public String headerOfResponse(String name) {
        return null;
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return Collections.emptyList();
    }

    public Collection<String> headerNamesOfResponse() {
        return Collections.emptyList();
    }

    public void cookieSet(String name, String val, String domain, String path, int maxAge) {
    }

    public void redirect(String url, int code) {
    }

    public int status() {
        return 0;
    }

    protected void statusDoSet(int status) {
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._response.close();
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
        if (!this._isAsync) {
            this._isAsync = true;
            if (listener != null) {
                this._asyncListeners.add(listener);
            }
            if (timeout != 0L) {
                this._asyncTimeout = timeout;
            }
            if (this._asyncTimeout > 0L) {
                RunUtil.delay(() -> {
                    for (ContextAsyncListener listener1 : this._asyncListeners) {
                        try {
                            listener1.onTimeout((Context)this);
                        }
                        catch (IOException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }, (long)this._asyncTimeout);
            }
        }
    }

    public void asyncComplete() throws IOException {
        if (this._isAsync) {
            try {
                this.innerCommit();
            }
            finally {
                this._asyncFuture.complete((Object)this);
            }
        }
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders(true);
        } else {
            this.status(404);
            this.sendHeaders(true);
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setStatusCode(this.status());
            if (isCommit || !this._allows_write) {
                this._response.putHeader("Content-Length", "0");
            }
        }
    }
}

